import sys
import logging

log = logging.getLogger(__name__)

try:
    import dbus
    import pydbus
except ImportError:
    log.warning(sys.exc_info())
    dbus = None
    pydbus = None

USC_DBUS_TYPE = "system"

def get_dbus_bus():    
    if USC_DBUS_TYPE == "session":
        return dbus.SessionBus()
    else:
        return dbus.SystemBus()

def get_pydbus_bus():    
    if USC_DBUS_TYPE == "session":
        return pydbus.SessionBus()
    else:
        return pydbus.SystemBus()

