"""Module containing a product specific class for the ONA-800 product
"""
from rest_api.products import metro_base
from rest_api.products import advisor_remote_control as arc
from rest_api.products.isu import job_manager_interface

import logging
log = logging.getLogger(__name__)

class ProductSpecific(metro_base.ProductSpecific):
    """Class for ONA-800 product specific functions
    """
    
    def __init__(self):
        super().__init__()

    @classmethod
    def startup_side_effect(cls, db_file, report_dir, procedures_dir, jobs_dir):
        super(ProductSpecific, ProductSpecific).startup_side_effect(
            db_file,
            report_dir,
            procedures_dir,
            jobs_dir
        )
        port = arc.get_isu_port()
        if port is None:
            log.warning("Unable to find ISU port number");
            return
        job_manager_interface.update_isu_in_thread_if_active(db_file, jobs_dir, port=port)

    @classmethod
    def update_job_side_effect(cls, job_info):
        port = arc.get_isu_port()
        if port is None:
            log.warning("Unable to find ISU port number");
            return
        job_manager_interface.send_job_info_to_isu(job_info, port)
