"""
Module handles sending notification of Jobs received from Mobile Tech to
appropriate service

and all instrument-specific implementation for the workflow endpoint
"""
import logging
import os
import json

from rest_api.products.mts_services.SCPI_Socket import SCPI_Socket
#from rest_api.api.job_manager.cdm_schemas_viavi import make_cdm_schema

log = logging.getLogger(__name__)

JOB_MANAGER_DIR = '/user/disk/job-manager/'
JOB_FILE_EXT = '.job.json'
TEMPLATE_FILE_EXT = '.tpl.json'

def get_job_dir():
    return JOB_MANAGER_DIR

def get_job_extension():
    return JOB_FILE_EXT

def get_template_extension():
    return TEMPLATE_FILE_EXT

# was previously def notify_job_received( file_path, job_type ):
def notify_job_changed( work_order_id, job_type ):
    """
    Sends a message to the instrument's job manager service about received workflow Jobs
    
    In MTS/T-BERD case,
    - for the legacy Job Mgr, this meant tell ISU to load a Job (with file_path) and kick-off Wrapper translations for this Job
    - for IJM, this means take into account that a job was activated / changed from one to another (IJM backend manages loading now)

    Note that this is happening both for requests from Mobile Tech and when the GUI is updated
    - Extended to notify for either Actived Job or Disactivated Job

    Args:
        

    Returns:
        True if the request was ack'd
    """

    ISU = SCPI_Socket('127.0.0.1',8000)
    ISU.debug_level(1)
    ISU.send("*rem")

    if (work_order_id is not None):
        log.debug('## notify_job_changed: workOrderId=%s, job_type=%s', work_order_id, job_type )
        success = ISU.send('workflow:newjob "%s",%s' %( work_order_id, job_type ))
    else:
        log.debug('## notify_job_changed: workflow:resetjob' )
        success = ISU.send('workflow:resetjob')

    ISU.close()

    return success
