"""Module containing api configurations specific to the mts-5800
"""
from rest_api.products.isu import job_manager_interface
from rest_api.products import metro_base

class ProductSpecific(metro_base.ProductSpecific):
    """Class for T-BERD/MTS-5800 product specific functions
    """

    def __init__(self):
        super().__init__()

    @classmethod
    def startup_side_effect(cls, db_file, report_dir, procedures_dir, jobs_dir):
        super(ProductSpecific, ProductSpecific).startup_side_effect(
            db_file,
            report_dir,
            procedures_dir,
            jobs_dir
        )
        job_manager_interface.update_isu_in_thread_if_active(
            db_file,
            jobs_dir,
            port=8002
        )

    @classmethod
    def update_job_side_effect(cls, job_info):
        job_manager_interface.send_job_info_to_isu(job_info, port=8002)
