"""
Module that contains schemas for RadioAnalysis Test Types
"""
from marshmallow import Schema, fields, validates_schema, ValidationError

from .config_schema_common import test_type_factory, config_factory

#pylint: disable=no-self-use


class RASASweepTunedSpectrum(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RF Sweep Tuned Spectrum')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RASAChannelPower(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RF Channel Power')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RASAOccupiedBandwidth(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RF Occupied Bandwidth')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RASASpectrumEmissionMask(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RF Spectrum Emission Mask')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RASAACLR(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RF ACLR')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RASAAdjacentChannelPower(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RF Adjacent Channel Power')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RASAMultiACLR(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RF Multi-ACLR')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RASAMultiAdjacentChannelPower(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RF Multi Adjacent Channel Power')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RASASpuriousEmissions(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RF Spurious Emissions')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RASATotalHarmonicDistortion(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RF Total Harmonic Distortion')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RASAFieldStrength(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RF Field Strength')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RASAAMFMAudioDemodulation(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RF AM/FM Demodulation')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RASAGatedSweep(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RF Gated Sweep')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RASARouteMap(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RF Route Map')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RAIASpectrum(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('IA Spectrum')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RAIASpectrogram(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('IA Spectrogram')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RAIARSSI(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('IA RSSI')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RAIAInterferenceFinder(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('IA Interference Finder')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RAIARadarChart(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('IA Radar Chart')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RAIAPIMDetectionSingleCarrier(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('IA PIM Detection Single Carrier')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RAIAPIMDetectionMultiCarrier(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('IA PIM Detection Multi Carrier')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RARtSAPersistentSpectrum(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RT Persistent Spectrum')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RARtSAPersistentSpectrogram(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RT Persistent Spectrogram')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RARtSAPersistentRSSI(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RT Persistent RSSI')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RARtSAPersistentInterferenceFinder(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RT Persistent Interference Finder')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RARtSAPersistentRadarChart(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RT Persistent Radar Chart')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RAChannelScanner(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('CS Channel Scanner')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RAFrequencyScanner(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('CS Frequency Scanner')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RACustomScanner(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('CS Custom Scanner')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTETDDSpectrum(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD Spectrum')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTETDDChannelPower(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD Channel Power')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTETDDOccupiedBandwidth(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD Occupied Bandwidth')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTETDDSpectrumEmissionMask(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD Spectrum Emission Mask')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTETDDAdjacentChannelPower(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD ACLR')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTETDDMultiAdjacentChannelPower(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD Multi-ACLR')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTETDDSpuriousEmissions(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD Spurious Emissions')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTETDDPowerVsTimeFrame(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD Power vs Time for Frame')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTETDDPowerVsTimeSlot(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD Power vs Time for Slot')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTETDDConstellation(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD Constellation')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTETDDDataChannel(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD Data Channel')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTETDDControlChannel(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD Control Channel')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTETDDSubframe(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD Subframe')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTETDDFrame(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD Frame')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTETDDTimeAlignmentError(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD Time Alignment Error')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTETDDDataAllocationMap(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD Data Allocation Map')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTETDDCarrierAggregation(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD Carrier Aggregation')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTETDDOTAChannelScanner(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD OTA Channel Scanner')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTETDDOTAIDScanner(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD OTA ID Scanner')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTETDDOTAMultipathProfile(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD OTA Multipath Profile')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTETDDOTAControlChannel(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD OTA Control Channel')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTETDDOTADatagram(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD OTA Datagram')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTETDDOTARouteMap(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD OTA Route Map')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTETDDFreqTimeErrorVariation(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD Freq / Time / Power Variation')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTETDDPowerStatisticsCCDF(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE TDD Power Statistics CCDF')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTEFDDSpectrum(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD Spectrum')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTEFDDChannelPower(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD Channel Power')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTEFDDOccupiedBandwidth(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD Occupied Bandwidth')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTEFDDSpectrumEmissionMask(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD Spectrum Emission Mask')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTEFDDAdjacentChannelPower(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD ACLR')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTEFDDMultiAdjacentChannelPower(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD Multi-ACLR')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTEFDDSpuriousEmissions(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD Spurious Emissions')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTEFDDPowerVsTimeFrame(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD Power vs Time for Frame')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTEFDDPowerVsTimeSlot(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD Power vs Time for Slot')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTEFDDConstellation(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD Constellation')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTEFDDDataChannel(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD Data Channel')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTEFDDControlChannel(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD Control Channel')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTEFDDSubframe(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD Subframe')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTEFDDFrame(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD Frame')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTEFDDTimeAlignmentError(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD Time Alignment Error')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTEFDDDataAllocationMap(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD Data Allocation Map')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTEFDDCarrierAggregation(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD Carrier Aggregation')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTEFDDOTAChannelScanner(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD OTA Channel Scanner')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTEFDDOTAIDScanner(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD OTA ID Scanner')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTEFDDOTAMultipathProfile(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD OTA Multipath Profile')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTEFDDOTAControlChannel(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD OTA Control Channel')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTEFDDOTADatagram(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD OTA Datagram')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTEFDDOTARouteMap(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD OTA Route Map')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTEFDDFreqTimeErrorVariation(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD Freq / Time / Power Variation')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RALTEFDDPowerStatisticsCCDF(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('LTE FDD Power Statistics CCDF')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RA5GNRTriggerSpectrum(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('5G NR Trigger Spectrum')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RA5GNRChannelPower(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('5G NR Channel Power')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RA5GNROccupiedBandwidth(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('5G NR Occupied Bandwidth')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RA5GNRSpectrumEmissionMask(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('5G NR Spectrum Emission Mask')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RA5GNRAdjacentChannelPower(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('5G NR ACLR')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RA5GNRMultiAdjacentChannelPower(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('5G NR Multi-ACLR')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RA5GNRSpuriousEmissions(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('5G NR Spurious Emissions')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RA5GNRBeamAnalyzer(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('5G NR Beam Analyzer')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RA5GNRCarrierScanner(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('5G NR Carrier Scanner')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RA5GNRRouteMap(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('5G NR Route Map')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RA5GNRBeamAvailabilityIndex(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('5G NR Beam Availability Index')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RA5GNRFreqTimeErrorVariation(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('5G NR Freq / Time / Power Variation')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RA5GNRConstellation(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('5G NR Constellation')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RA5GNRPowerVsTimeSymbol(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('5G NR Power vs Time for Symbol')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RA5GNRPowerVsTimeFrame(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('5G NR Power vs Time for Frame')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RARFInternalPowerMeter(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RFPM Internal RF Power Meter')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RARFExternalPowerMeter(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RFPM External RF Power Meter')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RANSAAnalyzer(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('NSA Analyzer')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RANSAScanner(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('NSA Scanner')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RANSARouteMap(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('NSA Route Map')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RARFoCPRISpectrum(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RFoCPRI Spectrum')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RARFoCPRISpectrogram(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('RFoCPRI Spectrogram')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RAEMFSpectrum(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('EMF Spectrum')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RAEMF5GNRBeamAnalysis(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('EMF 5G NR Beam Analysis')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RADSSSpectrum(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('DSS Spectrum')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RADSSChannelPower(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('DSS Channel Power')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RADSSOccupiedBandwidth(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('DSS Occupied Bandwidth')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RADSSSpectrumEmissionMask(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('DSS Spectrum Emission Mask')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RADSSAdjacentChannelPower(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('DSS ACLR')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RADSSMultiAdjacentChannelPower(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('DSS Multi-ACLR')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RADSSSpuriousEmissions(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('DSS Spurious Emissions')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RADSSPowerVsTimeFrame(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('DSS Power vs Time for Frame')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RADSSPowerVsTimeSlot(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('DSS Power vs Time for Slot')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RADSSConstellation(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('DSS Constellation')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RADSSChannelMapper(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('DSS Channel Mapper')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RADSSControlChannel(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('DSS Control Channel')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RADSSSubframe(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('DSS Subframe')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RADSSFrame(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('DSS Frame')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RADSSTimeAlignmentError(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('DSS Time Alignment Error')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RADSSOTAChannelScanner(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('DSS OTA Channel Scanner')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RADSSOTAIDScanner(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('DSS OTA ID Scanner')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RADSSOTAMultipathProfile(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('DSS OTA Multipath Profile')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RADSSOTAControlChannel(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('DSS OTA Control Channel')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RADSSOTARouteMap(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('DSS OTA Route Map')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')

class RADSSFreqTimeErrorVariation(Schema):
    """
    Schema for the configuration of a Radio Analysis Spectrum Analyzer Sweep Tuned Spectrum test
    """
    test_type = test_type_factory('DSS Freq / Time / Power Variation')
    config_file = config_factory('/user/RadioAnalysis/internal/strataSync/')



CONFIG_SCHEMAS = {
    'RF Sweep Tuned Spectrum': RASASweepTunedSpectrum,
    'RF Channel Power' : RASAChannelPower,
    'RF Occupied Bandwidth' : RASAOccupiedBandwidth,
    'RF Spectrum Emission Mask' : RASASpectrumEmissionMask,
    'RF ACLR' : RASAACLR,
    'RF Adjacent Channel Power' : RASAAdjacentChannelPower,
    'RF Multi-ACLR' : RASAMultiACLR,
    'RF Multi Adjacent Channel Power' : RASAMultiAdjacentChannelPower,
    'RF Spurious Emissions' : RASASpuriousEmissions,
    'RF Total Harmonic Distortion' : RASATotalHarmonicDistortion,
    'RF Field Strength' : RASAFieldStrength,
    'RF AM/FM Demodulation' : RASAAMFMAudioDemodulation,
    'RF Gated Sweep' : RASAGatedSweep,
    'RF Route Map' : RASARouteMap,
    'IA Spectrum' : RAIASpectrum,
    'IA Spectrogram' : RAIASpectrogram,
    'IA RSSI' : RAIARSSI,
    'IA Interference Finder' : RAIAInterferenceFinder,
    'IA Radar Chart' : RAIARadarChart,
    'IA PIM Detection Single Carrier' : RAIAPIMDetectionSingleCarrier,
    'IA PIM Detection Multi Carrier' : RAIAPIMDetectionMultiCarrier,
    'RT Persistent Spectrum' : RARtSAPersistentSpectrum,
    'RT Persistent Spectrogram' : RARtSAPersistentSpectrogram,
    'RT Persistent RSSI' : RARtSAPersistentRSSI,
    'RT Persistent Interference Finder' : RARtSAPersistentInterferenceFinder,
    'RT Persistent Radar Chart' : RARtSAPersistentRadarChart,
    'CS Channel Scanner' : RAChannelScanner,
    'CS Frequency Scanner' : RAFrequencyScanner,
    'CS Custom Scanner' : RACustomScanner,
    'LTE TDD Spectrum': RALTETDDSpectrum,
    'LTE TDD Channel Power' : RALTETDDChannelPower,
    'LTE TDD Occupied Bandwidth' : RALTETDDOccupiedBandwidth,
    'LTE TDD Spectrum Emission Mask' : RALTETDDSpectrumEmissionMask,
    'LTE TDD ACLR' : RALTETDDAdjacentChannelPower,
    'LTE TDD Multi-ACLR' : RALTETDDMultiAdjacentChannelPower,
    'LTE TDD Spurious Emissions' : RALTETDDSpuriousEmissions,
    'LTE TDD Power vs Time for Frame' : RALTETDDPowerVsTimeFrame,
    'LTE TDD Power vs Time for Slot' : RALTETDDPowerVsTimeSlot,
    'LTE TDD Constellation' : RALTETDDConstellation,
    'LTE TDD Data Channel' : RALTETDDDataChannel,
    'LTE TDD Control Channel' : RALTETDDControlChannel,
    'LTE TDD Subframe' : RALTETDDSubframe,
    'LTE TDD Frame' : RALTETDDFrame,
    'LTE TDD Time Alignment Error' : RALTETDDTimeAlignmentError,
    'LTE TDD Data Allocation Map' : RALTETDDDataAllocationMap,
    'LTE TDD Carrier Aggregation' : RALTETDDCarrierAggregation,
    'LTE TDD OTA Channel Scanner' : RALTETDDOTAChannelScanner,
    'LTE TDD OTA ID Scanner' : RALTETDDOTAIDScanner,
    'LTE TDD OTA Multipath Profile' : RALTETDDOTAMultipathProfile,
    'LTE TDD OTA Control Channel' : RALTETDDOTAControlChannel,
    'LTE TDD OTA Datagram' : RALTETDDOTADatagram,
    'LTE TDD OTA Route Map' : RALTETDDOTARouteMap,
    'LTE TDD Freq / Time / Power Variation' : RALTETDDFreqTimeErrorVariation,
    'LTE TDD Power Statistics CCDF' : RALTETDDPowerStatisticsCCDF,
    'LTE FDD Spectrum': RALTEFDDSpectrum,
    'LTE FDD Channel Power' : RALTEFDDChannelPower,
    'LTE FDD Occupied Bandwidth' : RALTEFDDOccupiedBandwidth,
    'LTE FDD Spectrum Emission Mask' : RALTEFDDSpectrumEmissionMask,
    'LTE FDD ACLR' : RALTEFDDAdjacentChannelPower,
    'LTE FDD Multi-ACLR' : RALTEFDDMultiAdjacentChannelPower,
    'LTE FDD Spurious Emissions' : RALTEFDDSpuriousEmissions,
    'LTE FDD Power vs Time for Frame' : RALTEFDDPowerVsTimeFrame,
    'LTE FDD Power vs Time for Slot' : RALTEFDDPowerVsTimeSlot,
    'LTE FDD Constellation' : RALTEFDDConstellation,
    'LTE FDD Data Channel' : RALTEFDDDataChannel,
    'LTE FDD Control Channel' : RALTEFDDControlChannel,
    'LTE FDD Subframe' : RALTEFDDSubframe,
    'LTE FDD Frame' : RALTEFDDFrame,
    'LTE FDD Time Alignment Error' : RALTEFDDTimeAlignmentError,
    'LTE FDD Data Allocation Map' : RALTEFDDDataAllocationMap,
    'LTE FDD Carrier Aggregation' : RALTEFDDCarrierAggregation,
    'LTE FDD OTA Channel Scanner' : RALTEFDDOTAChannelScanner,
    'LTE FDD OTA ID Scanner' : RALTEFDDOTAIDScanner,
    'LTE FDD OTA Multipath Profile' : RALTEFDDOTAMultipathProfile,
    'LTE FDD OTA Control Channel' : RALTEFDDOTAControlChannel,
    'LTE FDD OTA Datagram' : RALTEFDDOTADatagram,
    'LTE FDD OTA Route Map' : RALTEFDDOTARouteMap,
    'LTE FDD Freq / Time / Power Variation' : RALTEFDDFreqTimeErrorVariation,
    'LTE FDD Power Statistics CCDF' : RALTEFDDPowerStatisticsCCDF,
    '5G NR Trigger Spectrum' : RA5GNRTriggerSpectrum,
    '5G NR Channel Power' : RA5GNRChannelPower,
    '5G NR Occupied Bandwidth' : RA5GNROccupiedBandwidth,
    '5G NR Spectrum Emission Mask' : RA5GNRSpectrumEmissionMask,
    '5G NR ACLR' : RA5GNRAdjacentChannelPower,
    '5G NR Multi-ACLR' : RA5GNRMultiAdjacentChannelPower,
    '5G NR Spurious Emissions' : RA5GNRSpuriousEmissions,
    '5G NR Beam Analyzer' : RA5GNRBeamAnalyzer,
    '5G NR Carrier Scanner' : RA5GNRCarrierScanner,
    '5G NR Route Map' : RA5GNRRouteMap,
    '5G NR Beam Availability Index' : RA5GNRBeamAvailabilityIndex,
    '5G NR Freq / Time / Power Variation' : RA5GNRFreqTimeErrorVariation,
    '5G NR Constellation' : RA5GNRConstellation,
    '5G NR Power vs Time for Symbol' : RA5GNRPowerVsTimeSymbol,
    '5G NR Power vs Time for Frame' : RA5GNRPowerVsTimeFrame,
    'EMF Spectrum' : RAEMFSpectrum,
    'EMF 5G NR Beam Analysis' : RAEMF5GNRBeamAnalysis,
    'DSS Spectrum' : RADSSSpectrum,
    'DSS Channel Power' : RADSSChannelPower,
    'DSS Occupied Bandwidth' : RADSSOccupiedBandwidth,
    'DSS Spectrum Emission Mask' : RADSSSpectrumEmissionMask,
    'DSS ACLR' : RADSSAdjacentChannelPower,
    'DSS Multi-ACLR' : RADSSMultiAdjacentChannelPower,
    'DSS Spurious Emissions' : RADSSSpuriousEmissions,
    'DSS Power vs Time for Frame' : RADSSPowerVsTimeFrame,
    'DSS Power vs Time for Slot' : RADSSPowerVsTimeSlot,
    'DSS Constellation' : RADSSConstellation,
    'DSS Channel Mapper' : RADSSChannelMapper,
    'DSS Control Channel' : RADSSControlChannel,
    'DSS Subframe' : RADSSSubframe,
    'DSS Frame' : RADSSFrame,
    'DSS Time Alignment Error' : RADSSTimeAlignmentError,
    'DSS OTA Channel Scanner' : RADSSOTAChannelScanner,
    'DSS OTA ID Scanner' : RADSSOTAIDScanner,
    'DSS OTA Multipath Profile' : RADSSOTAMultipathProfile,
    'DSS OTA Control Channel' : RADSSOTAControlChannel,
    'DSS OTA Route Map' : RADSSOTARouteMap,
    'DSS Freq / Time / Power Variation' : RADSSFreqTimeErrorVariation,
    'NSA Analyzer' : RANSAAnalyzer,
    'NSA Scanner' : RANSAScanner,
    'NSA Route Map' : RANSARouteMap,
    'RFPM Internal RF Power Meter' : RARFInternalPowerMeter,
    'RFPM External RF Power Meter' : RARFExternalPowerMeter,
    'RFoCPRI Spectrum' : RARFoCPRISpectrum,
    'RFoCPRI Spectrogram' : RARFoCPRISpectrogram
}
