"""
Module that contains schemas for CAA Test Types
"""
from marshmallow import Schema, fields, validates_schema, ValidationError

from .config_schema_common import test_type_factory, config_factory

#pylint: disable=no-self-use


class CAAReflectionVSWR(Schema):
    """
    Schema for the configuration of a CAA ReflectionVSWR test
    """
    test_type = test_type_factory('CAA Reflection VSWR')
    config_file = config_factory('/user/caa/internal/StrataSync/')

class CAAReflectionReturnLoss(Schema):
    """
    Schema for the configuration of a CAA ReflectionReturnLoss test
    """
    test_type = test_type_factory('CAA Reflection Return Loss')
    config_file = config_factory('/user/caa/internal/StrataSync/')

class CAADTFVSWR(Schema):
    """
    Schema for the configuration of a CAA DTFVSWR test
    """
    test_type = test_type_factory('CAA DTF VSWR')
    config_file = config_factory('/user/caa/internal/StrataSync/')

class CAADTFReturnLoss(Schema):
    """
    Schema for the configuration of a CAA DTFReturnLoss test
    """
    test_type = test_type_factory('CAA DTF Return Loss')
    config_file = config_factory('/user/caa/internal/StrataSync/')

class CAA1PortCableLoss(Schema):
    """
    Schema for the configuration of a CAA 1 Port Cable Loss test
    """
    test_type = test_type_factory('CAA 1 Port Cable Loss')
    config_file = config_factory('/user/caa/internal/StrataSync/')

class CAACAA1PortPhase(Schema):
    """
    Schema for the configuration of a CAA 1 Port Phase test
    """
    test_type = test_type_factory('CAA 1 Port Phase')
    config_file = config_factory('/user/caa/internal/StrataSync/')

class CAACAA2PortTransmission(Schema):
    """
    Schema for the configuration of a CAA 2 Port Transmission test
    """
    test_type = test_type_factory('CAA 2 Port Transmission')
    config_file = config_factory('/user/caa/internal/StrataSync/')

class CAASmithChart(Schema):
    """
    Schema for the configuration of a CAA SmithChart test
    """
    test_type = test_type_factory('CAA Smith Chart')
    config_file = config_factory('/user/caa/internal/StrataSync/')

class CAACheckConfigSchema(Schema):
    """
    Schema for the configuration information of a CAA
    Check test
    """

    test_type = test_type_factory('CAA Check')
    config_file = config_factory('/user/caa/internal/StrataSync/')



CONFIG_SCHEMAS = {
    'CAA Reflection VSWR': CAAReflectionVSWR,
    'CAA Reflection Return Loss': CAAReflectionReturnLoss,
    'CAA DTF VSWR': CAADTFVSWR,
    'CAA DTF Return Loss': CAADTFReturnLoss,
    'CAA 1 Port Cable Loss': CAA1PortCableLoss,
    'CAA 1 Port Phase': CAACAA1PortPhase,
    'CAA Smith Chart': CAASmithChart,
    'CAA Check': CAACheckConfigSchema,
}
