"""Module containing api configurations specific to
   T-BERD/MTS-4000 V2, T-BERD/MTS-2000 V2, SmartOTDR instrument family
   ** with Job Manager feature enabled **
"""
import logging
import traceback

from rest_api.products import fiber_base

from rest_api.products.usc import asset_info

from rest_api.products.mts_services import update_asset_info
from rest_api.products.mts_services import instrument_jobs

from rest_api.api.job_manager.job_manager import JobManager

#from rest_api.api.workflow_v1 import exec_put_active_workorder, exec_get_active_workorder, exec_get_workorder
from rest_api.products.mts_services.SCPI_Socket import SCPI_Socket

from rest_api.products.mts_services.update_stratasync_info import get_instrument_login_config


log = logging.getLogger(__name__)

class ProductSpecific(fiber_base.ProductSpecific):
    """Class for T-BERD/MTS-4kv2 / 2kv2 / SmartOTDR specific functions
       ** with Job Manager feature enabled **
    """

    #Indicate that make_instrument_info can use cached info for this particular product    
    use_cached_instrument_info = True
    
    def __init__(self):
        super().__init__()

    @staticmethod
    def make_instrument_info():
        info_version = {'infoVersion':1}

        __version__ = '1.11.0' # Should we align this with latest Yocto project tag?
        __files_api_version__ = 1
        __job_manager_api_version__ = 2
        __workflow_api_version__ = [1,2]
        __location_api_version__ = 1
        __datetime_api_version__ = 1

        # Override api_support per product here
        api_support = {
            'apiSupport': [
                {
                    'name': 'datetime',
                    'versions': [__datetime_api_version__]
                },
                {
                    'name': 'location',
                    'versions': [__location_api_version__]
                },
                {
                    'name': 'techinfo',
                    'versions': [1]
                },
                {
                    'name': 'filemgr',
                    'versions': [__files_api_version__]
                },
                {
                    'name': 'syncfiles',
                    'versions': [1]
                },
                {
                    'name': 'signature',
                    'versions': [__files_api_version__]
                },
                {
                    'name': 'testdata',
                    'versions': [__files_api_version__]
                },
                {
                    'name': 'jobmanager',
                    'versions': [__job_manager_api_version__]
                },
                {
                    'name': 'saa',
                    'versions': [1]
                },
                {
                    'name': 'instrumentlogin',
                    'versions': [1]
                },
                {
                    'name': 'firmware',
                    'versions': [1]
                },
                #{
                    #'name': 'options',
                    #'versions': [1] 
                #},
                {
                    'name': 'workflow', # Mobile Tech endpoint for job_manager
                    'versions': __workflow_api_version__
                }

            ]
        }


        instrument_info = super(ProductSpecific, ProductSpecific).make_instrument_info()

        asset_info_usc = asset_info.make_asset_info()
        instrument_info['assetInfo'] = update_asset_info.update_asset_info(asset_info_usc)

        instrument_info.update(info_version)
        instrument_info.update(api_support)


        log.debug('## make_instrument_info: version                 = %s', __version__)
        log.debug('## make_instrument_info: job_manager_api_version = %s', __job_manager_api_version__)
        log.debug('## make_instrument_info: files_api_version       = %s', __files_api_version__)
        log.debug('## make_instrument_info: location_api_version    = %s', __location_api_version__)
        log.debug('## make_instrument_info: datetime_api_version    = %s', __datetime_api_version__)
        log.debug('## make_instrument_info: api_support: %s', api_support)

        return instrument_info


    @staticmethod
    def call_notify_job_received(work_order_id, cdm_job):
        try:
            job_type = ''
            log.debug('## call_notify_job_received for [%s]', cdm_job )

            # Different actions are needed for ATT job notification.
            # We determine if a jobs is for ATT TRUE Fiber here:
            # if workorder_id's LABEL contains BAN/TN then deduce we have the very particular AT&T situation... 
            # No Job Mgr, but a Job to deal with !!!
            # Also expect 1st (& only) testType in the Test Plan == trueFiber
            try:
                workorderlabel = cdm_job['workflow']['workOrderLabel']
            except:
                workorderlabel = ""
     
            try:
                single_test_type = cdm_job['tests'][0]['type']
            except:
                single_test_type = ""
     
            try:
                workorder_type = cdm_job['workflow']['type']
            except:
                workorder_type = ""

            log.debug('## call_notify_job_received: [%s] [%s] [%s]', workorderlabel, single_test_type, workorder_type )

            # TODO Move ATT decision out to "solution" code on Fiber products
            #
            if (workorderlabel == 'BAN' or workorderlabel == 'BAN/TN') and single_test_type == 'trueFiber' and workorder_type == 'viaviJob':
                # 'BAN' compatible with MTA4.2, 'BAN/TN' compatible with MTA 4.3
                log.debug('## call_notify_job_received -> (%s) Destined for ATT TRUE Fiber', work_order_id )
                job_type = 'ATT'
            else:
                log.debug('## call_notify_job_received -> (%s) Standard CDM Job heading for Job Manager', work_order_id )
                job_type = 'CDM'


            return( instrument_jobs.notify_job_changed( work_order_id, job_type ) )

        except:
            log.debug('## call_notify_job_received -> exception')
            print(traceback.format_exc())
            return False

    #TODO Figure out how this works with generic job manager
    ## It came from the need to ensure that Mobile Tech instrument login corresponds correctly with techIds in Jobs being received
    ## Should probably be generic for everyone...?
    # @staticmethod
    # def verify_and_set_active_job(job_manager):
    #     
    #     try:
    #         #active_workorder_id = exec_get_active_workorder(job_manager)
    #         job = job_manager.get_active_job()
    #         active_workorder_id = job['workflow']['workOrderId']
    #         log.debug('## verify_and_set_active_job: active_workorder_id = %s', active_workorder_id )
    # 
    #         if (len(active_workorder_id) > 0):
    #             #workorder = exec_get_workorder(active_workorder_id)
    #             try:
    #                 tech_id_wo = job['workflow']['techInfo']['techId']
    #             except:
    #                 tech_id_wo =  ''
    # 
    #             login_config = get_instrument_login_config()
    # 
    #             try:
    #                 tech_id_login = login_config['techId']
    #             except:
    #                 tech_id_login = ''
    # 
    #             if ((len(tech_id_wo) > 0) and (len(tech_id_login) > 0) and (tech_id_wo == tech_id_login)):
    #                 log.debug('## verify_and_set_active_job: tech id matches ok' )
    #                 #workorder_json = {"activeWorkOrderId": active_workorder_id}
    #                 #exec_put_active_workorder(workorder_json)
    #             else:
    #                 #active_workorder_id = ''
    #                 log.debug('## verify_and_set_active_job: workflow:resetjob' )
    #                 ISU = SCPI_Socket('127.0.0.1',8000)
    #                 ISU.debug_level(1)
    #                 ISU.send("*rem")
    # 
    #                 success = ISU.send('workflow:resetjob')
    # 
    #                 ISU.close()
    # 
    #     except:
    #         print(traceback.format_exc())
 
 
    @staticmethod
    def update_loaded_job_side_effect(is_job_active,job_status_ratio):
        """Default function executed as a result of
        a new job being loaded or a job being activated / deactivated
        """
        log.debug('Fiber: update_loaded_job_side_effect: is_job_active = %s', is_job_active)
        try:
            log.debug('Fiber: update_loaded_job_side_effect: jobs done:%s total jobs:%s', job_status_ratio['complete_count'],job_status_ratio['total_count'])
        except:
            log.debug('Fiber: no job_status_ratio available')
        
        # TBD Use of verify_and_set_active_job(job_manager) for Mobile Tech use, and notify_job_received (notify_job_updated?) for IJM GUI changes ?

        if (is_job_active == 0):
            log.debug('Fiber: === no active IJM job ===')
        else:
            log.debug('Fiber: === job is active ===')
        
        return True
        

