"""Module containing a function to update the StrataSync info on a 5800 series
product
"""
import logging
from clientmgr import utils


def update_stratasync_info(tech_id, account_id, url):
    """Function to update stratasync information on the 5800 series products

    Url arguments can optionally begin with `https://` only the hostname will be
    passed to the ctrlpannelsvc

    Args:
        tech_id (str): the stratasync techId for the technician
        account_id (str): the stratasync account_id for the technician's company
        url (str): the stratasync server url that the technician's company is using
    """
    try:
        utils.cmsend('127.0.0.1', 'ctrlpanelsvc', 'set', 'STRATASYNC_TECHNICIAN_ID,{}'.format(tech_id))
    except utils.ClientFactory.ConnectionError:
        pass
    if account_id:
        try:
            utils.cmsend(
                '127.0.0.1',
                'ctrlpanelsvc',
                'set',
                'STRATASYNC_ACCOUNT_ID,{}'.format(account_id)
            )
        except utils.ClientFactory.ConnectionError:
            pass
    if url:
        host = url[len('https://'):] if url.startswith('https://') else url
        try:
            utils.cmsend('127.0.0.1', 'ctrlpanelsvc', 'set', 'STRATASYNC_SERVER,{}'.format(host))
        except utils.ClientFactory.ConnectionError:
            pass

    return True

def get_stratasync_info():
    """Function to update stratasync information on the 5800 series products

    Url arguments can optionally begin with `https://` only the hostname will be
    passed to the ctrlpannelsvc

    Args:
        tech_id (str): the stratasync techId for the technician
        account_id (str): the stratasync account_id for the technician's company
        url (str): the stratasync server url that the technician's company is using
    """
    stratasync_info = {}
    try:
        techid = utils.cmsend('127.0.0.1', 'ctrlpanelsvc', 'get', 'STRATASYNC_TECHNICIAN_ID')
        accountid = utils.cmsend('127.0.0.1', 'ctrlpanelsvc', 'get', 'STRATASYNC_ACCOUNT_ID')
        server = utils.cmsend('127.0.0.1', 'ctrlpanelsvc', 'get', 'STRATASYNC_SERVER')
        stratasync_info['techId'] = techid.parameters
        stratasync_info['accountId'] = accountid.parameters
        stratasync_info['stratasync_server'] = server.parameters
    except :
        pass
    return stratasync_info