"""Module containing functions to edit firmwareInfo and swVersion
"""
import re
import json

def update_asset_info(asset_info):
    software_versions = asset_info['swVersion']
    formatted_firmware_info = split_firmware_infos(software_versions)
    
    soft_version = get_fo_version(formatted_firmware_info)
    
    asset_info_updated = asset_info
    asset_info_updated['swVersion'] = soft_version
    asset_info_updated['firmwareInfo'] = formatted_firmware_info
    
    return asset_info_updated

def split_firmware_infos(firmware_infos):
    firmware_infos_split = re.split(';|,', firmware_infos)
    
    res = []
    for firmware_info in firmware_infos_split:
        firmware_info_split = firmware_info.split(':')
        
        try:
            name = firmware_info_split[0]
        except:
            name = ""
        
        try:
            version = firmware_info_split[1]
        except:
            version = ""
        
        try:
            date = datetime.strptime(firmware_info_split[2], "%d/%m/%Y")
            timestamp = (date - datetime(1970, 1, 1)).total_seconds()
            update_on = int(round(timestamp*1000))
        except:
            update_on = 0
        
        firmware = {
            "name": name,
            "version": version,
            "updateOn": update_on
            }
        
        res.append( firmware )
        
    return res

def get_fo_version(formatted_firmware_info):
    for firmware_info in formatted_firmware_info:
        if 'ONA-800' in firmware_info['name']:
            return firmware_info.get('version', 'unknown')
        
    return ''
