"""
Module handles sending time update info to
appropriate service to update the system time
"""

from clientmgr import utils
from clientmgr.utils import ClientFactory
import pytz

def update_local_time(time_value, location):
    """
    Sends a message to the instrument time service to update the local
    time

    Args:
        time_value {[DateTime]} -- [IEEE 8601 formatted datetime object]
        location (string): A string representation of the timezone (not used so far)
    Returns:
        True if the request was ack'd
    """
    local_time = time_value.isoformat()

    try:
        utils.cmsend('127.0.0.1', 'chronometer', 'update_time', local_time, 10)
    except ClientFactory.ConnectionError:
        pass
    return True

def update_utc_time(time_value):
    """
    Sends a message to the instrument time service to update the
    system utc time

    Args:
        time_value {[DateTime]} -- [IEEE 8601 formatted datetime object]

    Returns:
        True if the request was ack'd
    """
    utc_time = utc_from_local_time(time_value)
    try:
        utils.cmsend('127.0.0.1', 'chronometer', 'update_time', utc_time, 10)
    except ClientFactory.ConnectionError:
        pass
    return True

def utc_from_local_time(time_value):
    """

    Arguments:
        time_value {[DateTime]} -- [IEEE 8601 formatted datetime object]

    Returns:
        time string converted to utc
    """
    return time_value.astimezone(pytz.utc).isoformat()
