"""
Module handles sending location info to
appropriate service to update the instrument
location
"""

from clientmgr.utils import cmsend
from clientmgr.utils import ClientFactory
try:
    import dbus
except:
    dbus=None

def update_location(latitude, longitude, altitude):
    """
    Sends a message to the instrument location service to update the
    location

    Args:
        latitude
        longitude
        altitude

    Returns:
        True if the request was ack'd
    """
    location_str = ",".join([str(latitude), str(longitude), str(altitude)])
    try:
        cmsend('127.0.0.1', 'location', 'update_location', location_str, 10)
    except ClientFactory.ConnectionError:
        pass

    try:
        bus = dbus.SessionBus()
        applicationObject = bus.get_object("gem.base.starter_app","/")
        elf = dbus.Interface(applicationObject, dbus_interface='jdsu.elf')
        elf.SetValue([(":config:starter_app:starter_reg_module:latitudeGpsExt:",str(latitude))], signature="a(sv)")
        elf.SetValue([(":config:starter_app:starter_reg_module:longitudeGpsExt:",str(longitude))], signature="a(sv)")
        elf.SetValue([(":config:starter_app:starter_reg_module:availableGpsExt:","true")], signature="a(sv)")

    except dbus.DBusException:
        pass

    try:
        applicationObject = bus.get_object("gem.base.cableAntennaAnalyzer_app","/")
        elf = dbus.Interface(applicationObject, dbus_interface='jdsu.elf')
        elf.SetValue([(":config:cableAntennaAnalyzer_app:cableAntennaAnalyzer_reg_module:latitudeGpsExtCnfg:",str(latitude))], signature="a(sv)")
        elf.SetValue([(":config:cableAntennaAnalyzer_app:cableAntennaAnalyzer_reg_module:longitudeGpsExtCnfg:",str(longitude))], signature="a(sv)")
        elf.SetValue([(":config:cableAntennaAnalyzer_app:cableAntennaAnalyzer_reg_module:availableGpsExtCnfg:","true")], signature="a(sv)")

    except dbus.DBusException:
        pass

    return True
