"""
Module that contains schemas for the config information of different tests to
launch on the OneExpert product family
"""
import logging

from marshmallow import Schema, fields, validates_schema, ValidationError
from marshmallow.validate import OneOf
from marshmallow_oneofschema import OneOfSchema

from .config_schema_common import ConfigBase, test_type_factory, config_factory

log = logging.getLogger(__name__)

class wifiScanSchema(Schema):
    """Schema for the wifi scan : configuration of an wifiScan test
    """
    test_type = 'wifiScan'

CONFIG_SCHEMAS = {'wifiScan': wifiScanSchema}

class ConfigSchema(ConfigBase):
    """
    Polymorphic mapping for different CDM ConfigSchemas
    """
    def _load(self, data, partial=None):
        log.debug('## ConfigSchema._load: data = %s', data )

        if 'wifiScan' not in data:
            log.debug('##        ConfigSchema is for an wifiScan' )
            data['testType'] = 'wifiScan' # 'otdrSettings' #'CDMOTDR'
        return super(ConfigSchema, self)._load(data)

    type_schemas = CONFIG_SCHEMAS
