"""
Module that contains schemas for the config information of different tests to
launch on the CellAdvisor5G product family
"""
from marshmallow import Schema, fields, validates_schema, ValidationError
from marshmallow.validate import OneOf

from .config_schema_common import ConfigBase, test_type_factory
from rest_api.products import config_schemas_5800 as common
import importlib
import logging

#---------------------
#logger initialization
#---------------------
logger = logging.getLogger(__name__)

#pylint: disable=no-self-use

#-------------------------------------
#define list of modules to be imported
#-------------------------------------
modules = ["module_schemas_caa", "module_schemas_ra"]


CONFIG_SCHEMAS = {'Fiber Inspection': common.FiberInspectionSchema,
                  'opticalPower': common.PowerMeterConfigSchema,
                  'AntennaAlign': common.RfVisionAntennaAlignConfigSchema,
                  'MicrowaveAlign': common.RfVisionMicrowaveAlignConfigSchema,
                 }

#------------------
#import all modules
#------------------ 
for module_str in modules:
   try:
       #logger.info('Loading ONA-800 module=%s', module_str)
       module = importlib.import_module('rest_api.products.{}'.format(module_str), package=None)
       CONFIG_SCHEMAS.update(module.CONFIG_SCHEMAS)
       #logger.info('Successfully loading ONA-800 module=%s', module_str)
   except ImportError as error:
       logger.error('Failed to import module=%s.  Error=%s', module_str, str(error))
       pass

class ConfigSchema(ConfigBase):
    """
    Polymorphic mapping for different ConfigSchemas
    """
    type_schemas = CONFIG_SCHEMAS
