"""
Module containing endpoints for the VNC API
"""
from bottle import Bottle, response, request

api_node = Bottle()  #pylint: disable=invalid-name
__api_version__ = 1
__api_name__ = "vnc"

@api_node.put('/api/vnc/v1/credentials')
def vnc_credentials():
    """
    Endpoint to connect instrument to vnc
    service
    ---
    put:
        tags:
          - vnc
        description: tells instrument to attempt connection to vnc server
        responses:
            201:
                description: Success vnc credentials have been created
                schema:
                    $ref: '#/definitions/VNC'
            503:
                description: >-
                    Failure vnc credentials have not been created
                schema:
                    $ref: '#/definitions/VNC'
    """
    request.body.getvalue().decode('utf-8') #pylint: disable=no-member
    product_specific = api_node.config['rest_api.product_specific']
    vnc = product_specific.get_vnc_credentials('127.0.0.1')
    if vnc.port != 0:
        response.status = 201
    else:
        response.status = 503

    return vnc._asdict()

@api_node.delete('/api/vnc/v1/credentials')
def vnc_delete_credentials():
    """
    Nothing needs to be done, just send success confirmation
    """
    response.status = 200

    return {}
