"""
Module containing endpoints for the job manager api
"""
from webargs.bottleparser import use_args
from bottle import request, response, Bottle
from rest_api.schemas import StrataSyncSchema

api_node = Bottle()  # pylint: disable=invalid-name
__api_version__ = 1
__api_name__ = "techinfo"

@api_node.post('/api/v1/techinfo')
@use_args(StrataSyncSchema(strict=True))
def update_ss_info(args):
    """Endpoint for updating StrataSync information on an instrument
    This endpoint receives StrataSync tech info from the Mobile Tech app and
    updates that information on the instrument
    ---
    post:
      summary: Assign techId on instrument
      description: >
        Assigns the techId on the instrument to match the techId in StrataSync
        if the StrataSync field 'techUpdatedOnSS' is true. Updates the tech
        first name and tech last name, as well.
      tags:
        - tech info
      parameters:
        - in: body
          name: body
          required: true
          schema: StrataSyncSchema
      responses:
        200:
          description: Success
        404:
          description: No response from instrument

    """
    request.body.read()

    product_specific = api_node.config['rest_api.product_specific']
    success = product_specific.update_stratasync_info(**args)

    if success:
        response.status = 200
    else:
        response.status = 400

    return {}
