"""
Module containing endpoints for the job manager api
"""
from webargs.bottleparser import use_args
from bottle import request, response, Bottle
from rest_api.schemas import OptionsSchema
import logging

log = logging.getLogger(__name__)

api_node = Bottle()  # pylint: disable=invalid-name
__api_version__ = 1
__api_name__ = "options"

@api_node.put('/api/v1/options')
@use_args(OptionsSchema(strict=True))
def set_options(options):
    """
    Endpoint to deploy options from StrataSync to the instrument

    See doc at https://conf1.ds.jdsu.net/wiki/display/MOBILE/Mobile+Tech+REST+API


    options  : Valid on 2022-06-13
    type: object
    required:
      - name
      - serialNo
      - assetType
      - model
      - uniqueId
      - fwDeployTime
      - key


    ---
    put:
        tags:
          - options
        description: Deploy options from StrataSync via mobile tech app
        responses:
            200:
                description: Success
                'schema':
                    title: options
                    type: list of objects
            404:
                description: No response from instrument
    """
    product_specific = api_node.config['rest_api.product_specific']
    success = product_specific.update_options(options["options"])

    if success:
        response.status = 200
    else:
        response.status = 404

    return {}
