<html>
<style media="all" type="text/css">
.planned_test
{
    background-color: #DADADA;
    padding-left:40px;
    padding-top:5px;
    padding-bottom:5px;
    position:relative;
}

.planned_test_box
{
    page-break-inside: avoid;
}

.report_table
{
   width:90%;
   margin: auto;
   font-family: arial;
}
.status {
    display:inline;
    position:absolute;
    font-weight: bold;
    right:0;
    font-size: 17px;
    width:15%;
}
.verdict{
   position:absolute;
   right:0;
   bottom:5px;
   display:inline;
   width:15%;
   font-weight: bold;
}
.test_type
{
    position:relative;
    font-size: 17px;
    width:35%;
    display:inline-block;
    vertical-align:top;
    inline-block:left;
}

.test_type_data
{
    position:relative;
    font-size: 17px;
    display:inline-block;
    vertical-align:top;
    inline-block:left;
}

.reference_info_data
{
    word-break: break-word;
    font-size: 15px;
}

.reference_info_box_planned
{
   display:inline-block;
   width:45%;
   position:relative;
}


.reference_info
{
    font-size: 15px;
    list-style-type:none;
}

.job_info_key
{
    font-size: 20px;
    font-weight: bold;
}

.job_info_value
{
    font-size: 20px;
}

.test_data, .test_data_dark
{
    background-color: #F2F2F2;
    font-size: 17px;

    padding-left:40px;
    padding-top:5px;
    padding-bottom:5px;
    position:relative;
    word-break: break-all;
}
.comment
{
    background-color: #F2F2F2;
    margin-left: 10px;
    position:relative;
}

.test_data_dark
{
    background-color: #DBDBDB;
}

.header
{
    background-color: #500778;
    color: #FFFFFF;
    padding-left:40px;
    padding-top:10px;
    padding-bottom:10px;
    font-size:25px;
}

.job_info
{
    background-color: #F2F2F2;
    padding-left:40px;
    padding-top:5px;
    padding-bottom:5px;
}

.title
{
   text-align:center;
}

.title_text
{
   font-size:30px;
   margin-left:20px;
   font-family: arial;
}

.logo
{
   display:inline-block;
   align:left;
   width:200px;
}

.customer_logo
{
    display:inline-block;
    float:right;
    max-height:70px;
}

.test_data_table
{
    width:100%;
    table-layout: fixed;
    border-collapse: collapse;
    page-break-inside:auto;
    background-color: #DBDBDB;
}

tr
{
    page-break-inside:avoid;
    page-break-after:auto
}

td
{
    padding-top:5px;
    padding-bottom:5px;
    vertical-align: middle;
}

td:first-child
{
    padding-left:40px;
    width:25%;
    word-break: break-word;
}

td + td
{
    width:35%;
    padding-left:10px;
}

td + td + td
{
    width:30%;
    padding-left:10px;
    word-break: break-all;
}

td + td + td + td
{
    width:10%;
    padding-left:10px;
}

.pass
{
    color:#44A237;
}

.fail
{
    color:red;
}

.marginal
{
    color:goldenrod;
}
</style>

   <img class="logo" src="viavi_logo.png">

%import os
%if job.get_logo() and os.path.isfile(job.get_logo()):
   <img class="customer_logo" src={{job.get_logo().replace(" ", "%20")}}>
%end

   <div class="title" style="clear: right">
      <br>
      <span class="title_text"><b>{{i18n_strings['Summary Report']}}</b></span>
   </div>
   <br>
   <br>
<section>
   <div class="report_table">
      <div class="header">Job Information</div>
      %for attribute, val in job.get_job_info_html_format().items():
          %if val:
              <div class="job_info">
                 <span class=job_info_key>{{i18n_strings[attribute]}}:  </span>
                 <span class=job_info_value>{{val}}</span>
              </div>
          %end
      %end
   </div>
</section>

<section>

%if job.cdm_job['tests']:
<div class="report_table">
   <div class="header">Test Plan</div>
    % for planned_test in job.get_test_plan_html_format():
        <div class="planned_test_box">
            <div class="planned_test">
            % if planned_test['test_type'] == 'Manual Step':
                <span class="test_type"><b>{{planned_test['test_label']}}</b></span>
            % elif planned_test.get('test_label'):
                <span class="test_type"><b>{{planned_test['test_label']}}</b></span>
            % else:
                <span class="test_type"><b>{{planned_test['test_type']}}</b></span>
            % end
                <span class="reference_info_box_planned">
                    % for key, val in planned_test['reference_info'].items():
                        <li class="reference_info"><b>{{key}}</b>: {{val}}</li>
                    % end
                </span>
                <span class="status">{{!planned_test['status']}}</span>
            </div>
            % for test_data in planned_test['test_data']:
                <div class="test_data">
                    <span class="filename">{{test_data['filename']}}</span>
                    <span class="verdict">{{!test_data['verdict']}}</span>
                </div>
                %if "comments" in test_data:
                <div class="comment">
                    <span class="comments">{{test_data['comments']}}</span>
                </div>
                %end
             % end
           </div>
     % end
</div>
<br>
<br>
% end
   <div class="report_table">

       % if job.has_required_test() and job.has_other_test_data():
           <div class="header">Additional Test Data</div>
       % elif job.has_other_test_data():
           <div class="header">Test Data</div>
       % end
       <table class="test_data_table">
       % for test_data in job.get_test_data_html_format():
           <tr class="test_data_dark">
                % if test_data.get('test_label'):
                    <td><span class="test_type_data"> {{test_data['test_label']}}</span></td>
                % else:
                    <td><span class="test_type_data"> {{test_data['test_type']}}</span></td>
                % end
               <td>
                   % for key, val in test_data['reference_info_str_list'].items():
                       <li class="reference_info"><b>{{key}}</b>: {{val}}</li>
                   % end
               </td>
               <td>{{test_data['filename']}}</td>
               <td>{{!test_data['verdict']}}</td>
           </tr>
           %if "comments" in test_data:
           <tr class ="comment">
               <td colspan="5">
                    {{test_data['comments']}}
               </td>
           </tr>
           %end
       % end
       </table>
   </div>
   </section>
</html>
