import datetime
import time
import copy
import logging
from .helper import get_local_timestamp_8601, set_job_modified_to_now
from .cdm import cdm_schemas
log = logging.getLogger(__name__)

default_template_typename = 'Default Job'

default_template = {
    'cdmVersion': cdm_schemas.CURRENT_CDM_VERSION,
    'tests': [],
    'workflow': {
        "template": True,
        "typeName": default_template_typename,
        'type': 'viaviJob',
        'workOrderId': '',
        'customerInfo': {'company': ''},
        'techInfo': {'techId': ''},
        }
}


def convert_template_to_job(cdm_template, workOrderId="", techId=""):
    """Function create a job from a template
    args:
        cdm_template (CdmJob): based off an existing template. If workOrderId and techId are not supplied, assume that the template has been updated with these attributes
    Returns: The new CDM job or None if something went wrong        
    """
    cdm_job = copy.deepcopy(cdm_template)
    cdm_job["workflow"]["template"] = False
    if workOrderId:
        cdm_job["workflow"]["workOrderId"] = workOrderId
    elif not "workOrderId" in cdm_job["workflow"]:
        log.debug('convert_template_to_job error: no workOrderId specified')
        return None
    if techId:
        if not "techInfo" in cdm_job["workflow"]:
            cdm_job["workflow"]["techInfo"] = {}
        cdm_job["workflow"]["techInfo"]["techId"] = techId
    elif not "techInfo" in cdm_job["workflow"] or not "techId" in cdm_job["workflow"]["techInfo"]:
        log.debug('convert_template_to_job error: no techId specified')
        return None
    if "cdmVersion" not in cdm_job:
        cdm_job["cdmVersion"] = cdm_schemas.CURRENT_CDM_VERSION
    cdm_job["workflow"]["date"] = get_local_timestamp_8601()
    set_job_modified_to_now(cdm_job)
    return cdm_job


