"""
Module that contains common Viavi schemas for the rest api
in line with CDM2.1
"""
from marshmallow import Schema, fields
from marshmallow.validate import OneOf, Length

#from .schemas import FilePathSchema, ArtifactSchema, ReferenceInfoSchema

UI_STRING_VALIDATOR = Length(max=256)  # 256 to be aligned with buffer-size using on Instruments code

class FilePathSchema(Schema):
    """
    Schema for for creating summary reports
    """
    file_path = fields.Str(required=True,
                           load_from='filePath',
                           dump_to='filePath',
                           description=('The path to the file on the local'
                                        ' file system'))

class ActiveWorkOrderIdSchema(Schema):
    """
    Schema for for creating summary reports
    """
    activeWorkOrderId = fields.Str(required=True,description=('The active work order ID'))

class TestIndexSchema(Schema):
    """
    Schema for test index
    """
    index = fields.Str(required=True,description=('The test index'))

class ArtifactSchema(FilePathSchema):
    """
    Schema for creating job artifacts such as summary reports, consolidated
    reports, and zip files containing test reports and files
    """
    report_type = fields.Str(
        load_from='reportType', dump_to='reportType', missing='summary', validate=OneOf(
            ('summary', 'consolidated')), description=(
                'The desired type of report to create '
                'either a brief summary report or a '
                'consolidated report with all PDF files '
                'in the job appended to a summary report'))
    create_zip = fields.Bool(
        load_from='createZip', dump_to='createZip', missing=False, description=(
            'Whether or not to create a zip file containing the '
            'summary or consolidated report and all of the test '
            'data files in the job'))

