"""
Module containing code to save image files as pdfs
"""
import os
import datetime
import time

from rest_api.api.job_manager import save_job_artifacts
import logging
log = logging.getLogger(__name__)

def save_image_to_pdf(image_path, logo_path, image_type, job, pdf_file_path=None):
    """Function to save the image to a pdf

    Args:
        image_path (str): the filepath of the image
        logo_path (str): the filepath of the customer logo
        image_type (str): the type of image being saved
        job (Job): the active job object
        pdf_file_path (str): optional file path for the resulting pdf. If not specified
    the image_path will be used

    Returns:
        test_data (dict): the dictionary of the test data for the file
    """
    if not pdf_file_path:
        root, _ = os.path.splitext(image_path)
        pdf_file_path = root + '.pdf'
    
    parent_dir = os.path.dirname(pdf_file_path)
    if not os.path.exists(parent_dir):
        os.makedirs(parent_dir)

    try:
        save_job_artifacts.save_image_to_pdf(
            logo_path=logo_path,
            image=image_path,
            file_path=pdf_file_path,
            job=job,
            image_type=image_type,
        )
    except:
        log.error("save_image_to_pdf failed")
        pdf_file_path = None

    # test time here cant be empty
    # leading to bugs in UI 
    test_data = {
        'type': image_type,
        'results': {
            'status': 'none',
            'testTime': datetime.datetime.utcfromtimestamp(time.time()).isoformat() + "+00:00",
            'data': {
                'ijm_filePath': pdf_file_path
            }
        }
    }

    os.remove(image_path)

    return test_data