import logging
import traceback
log = logging.getLogger(__name__)
from rest_api.api.job_manager.helper import cdmtest_applies_to_instrument

def filter_applicable_tests(cdm_job, assetType, model):
    if not cdm_job.get('tests'):
        return []
    tests = [test for test in cdm_job['tests'] if cdmtest_applies_to_instrument(test, assetType, model)]
    return tests

def job_status(cdm_job, assetType, model):
    # This function is solely used for creating metadata
    # Can only return incomplete, fail, and pass (backwards compatibility)
    fail_count = 0
    incomplete_count = 0
    tests = filter_applicable_tests(cdm_job, assetType, model)
    if not cdm_job.get('tests'):
        return None
    for test in tests:
        if (test.get('testLocations')) and (len(test['testLocations']) > 1):
            for testLoc in test['testLocations']:
                if (not testLoc.get('results')) or (testLoc['results']['status'] == 'To Do'):
                    incomplete_count += 1
                elif testLoc['results']['status'] == 'fail':
                    fail_count += 1
        else:
            if (not test.get('results')) or (test['results']['status'] == 'To Do'):
                incomplete_count += 1
            elif test['results']['status'] == 'fail':
                fail_count += 1
    if incomplete_count:
        return 'Incomplete'
    elif fail_count:
        return 'Fail'
    return 'Pass'

def job_status_ratio(cdm_job, assetType, model):
    """Ratio of the job items that are complete to the total number of job items
    in the job

    Returns a dictionary: complete_count and total_count
    """
    status_ratio_dict = {
        'complete_count': 0,
        'total_count': 0
    }
    try:
        tests = filter_applicable_tests(cdm_job, assetType, model)
        if not cdm_job.get('tests'):
            return status_ratio_dict
        completed_count = 0
        total_items_count = 0
        for test in tests:
            #See if our results are stored under locations.
            #First check that testLocations exist and that results are stored in testLocations.
            testRequired = test.get('required', True)
            if testRequired == False:
                pass
            elif test.get('testLocations') and len(test['testLocations']) >= 0:
                # if testLocations present and size more than 1 then count each test location separately...
                for testLoc in test['testLocations']:
                    if testLoc.get('required', True):
                        total_items_count += 1
                        status = None
                        if 'results' in testLoc: 
                            status = testLoc['results'].get('status')
                        if status and status != 'To Do':
                            completed_count += 1
            #There is either no location or a single location and results are stored at test rather than location.
            elif test.get('required', True):
                # ...otherwise count the test as a whole
                total_items_count += 1
                status = None
                if 'results' in test: 
                    status = test['results'].get('status')
                if status and status != 'To Do':
                    completed_count += 1

        status_ratio_dict['complete_count'] = completed_count
        status_ratio_dict['total_count']    = total_items_count

    except:
        log.debug(traceback.format_exc())
    
    return status_ratio_dict



