import glob
import importlib 
import sys
import logging
import traceback
#https://conf1.ds.jdsu.net/wiki/display/PSP/ONA+Job+Manager+Solution+Test+Definition+Specification

log = logging.getLogger(__name__)

#Import solutions installed test definitions/schema files (e.g. https://cosgit1.ds.jdsu.net/projects/CA5G/repos/ca5g/browse/jobmanager/installer/module_schemas_ra.py)
def import_test_definitions(import_pydir):
    if not import_pydir.endswith("/"):
        import_pydir += "/"
    #Add the import path to our python
    sys.path.append(import_pydir)
    log.debug("import_test_definitions import_pydir: {}".format(import_pydir))
    test_definitions = {}
    #Recursively find python files in our directory
    for py in glob.glob("{}/**/*.py".format(import_pydir), recursive = True):
        #String the base path and py extension
        #For subdirs replace "/" with "."        
        try:
            py = py.replace(import_pydir,"").strip(".py").replace("/",".")
            definition_module = importlib.import_module(py)
            log.debug("import_test_definitions imported: {}".format(py))
            test_definitions.update(definition_module.CONFIG_SCHEMAS)
        except:
            log.error("Failed to import test definition module: {}".format(py))
            log.debug(traceback.format_exc())
    return test_definitions

