"""
Module containing endpoints for the job manager api
"""
from webargs.bottleparser import use_args
from bottle import request, response, Bottle
from rest_api.schemas import InstrumentLoginCredentialsSchema


api_node = Bottle()  # pylint: disable=invalid-name
__api_version__ = 1
__api_name__ = "instrumentlogin"

@api_node.get('/api/instrumentlogin/v1/config')
def instrument_login_config():
    """
    Endpoint to get information about the instrument login config
    ---
    get:
        tags:
          - info
        description: gets information specific to this instrument
        responses:
            200:
                description: Success.
                'schema': {'$ref': '#/definitions/AssetInfo'}
    """
    product_specific = api_node.config['rest_api.product_specific']
    login_config = product_specific.get_instrument_login_config()

    if not login_config:
        response.status = 404

    return login_config

@api_node.post('/api/instrumentlogin/v1/credentials')
@use_args(InstrumentLoginCredentialsSchema(strict=True))
def instrument_login_credentials(loginConfig):
    """
    Endpoint to get information about the instrument login config
    ---
    get:
        tags:
          - info
        description: gets information specific to this instrument
        responses:
            200:
                description: Success.
                'schema': {'$ref': '#/definitions/AssetInfo'}
    """
    product_specific = api_node.config['rest_api.product_specific']
    login_credentials = product_specific.get_instrument_login_credentials(loginConfig)

    if not login_credentials:
        response.status = 404

    return login_credentials
