"""
Module containing endpoints for the job manager api
"""
from webargs.bottleparser import use_kwargs, use_args
from marshmallow import Schema, fields
from bottle import request, response, Bottle

from rest_api.api.job_manager.plugin import JobManagerPlugin

api_node = Bottle()  # pylint: disable=invalid-name

@api_node.get('/info', apply=JobManagerPlugin())
def instrument_info(job_manager):
    """
    Endpoint to get information about the instrument for StrataSync
    ---
    get:
        tags:
          - info
        description: gets information specific to this instrument
        responses:
            200:
                description: Success.
                'schema': {'$ref': '#/definitions/AssetInfo'}
    """
    product_specific = api_node.config['rest_api.product_specific']

    product_specific.reset_firmware_upgrade_status()
    info = product_specific.make_instrument_info()

    product_specific.verify_and_set_active_job(job_manager)


    return info


@api_node.get('/userfiles/list')
def user_files_list():
    """
    Endpoint to get flattened list of user files
    ---
    post:
        tags:
          - info
        description: Currently just dummy endpoint to facilitate mobile tech connectivity
        responses:
            200:
                description: Success
                'schema':
                  type: object
                  properties:
                    UserFilesList:
                      items:
                        type: object
                      type: array
    """
    return {'UserFilesList': []}

@api_node.get('/api/v1/batteryinfo')
def process_batteryinfo_request():
    product_specific = api_node.config['rest_api.product_specific']
     
    (success, info) = product_specific.process_batteryinfo_request()

    if not success:
        response.status = 400

    return info
