"""
Module containing endpoints for the job manager api
"""
from webargs.bottleparser import use_kwargs
from bottle import request, response, Bottle

api_node = Bottle()  # pylint: disable=invalid-name
__api_version__ = 1
__api_name__ = "firmware"

@api_node.get('/api/firmware/v1/status')
def process_firmware_upgrade_status():
    """
    Endpoint to get firmware status
    ---
    see doc : https://conf1.ds.jdsu.net/wiki/display/MOBILE/Mobile+Tech+REST+API


    get:
        tags:
          - info
        description: gets information specific to this instrument
        responses:
            200:
                description: Success.
                'schema': {'$ref': '#/definitions/AssetInfo'}
    """
    product_specific = api_node.config['rest_api.product_specific']

    info = product_specific.process_firmware_upgrade_status()

    return info



@api_node.put('/api/firmware/v1/upgrade')
def PutFirmwareStatus1():
    """
    see doc : https://conf1.ds.jdsu.net/wiki/display/MOBILE/Mobile+Tech+REST+API
    See also https://conf1.ds.jdsu.net/wiki/pages/viewpage.action?spaceKey=UNIV&title=Assets+REST+API#AssetsRESTAPI-SampleResponse.6

    """

    product_specific = api_node.config['rest_api.product_specific']
    success = product_specific.process_firmware_upgrade_put(request)


    if success:
        response.status = 200
    else:
        response.status = 400

    return {}



@api_node.post('/api/firmware/v1/upgrade/<FileName>')
#@use_kwargs(UploadArgs())
#def PostFirmwareStatus2(filedata, FileName):
def PostFirmwareStatus2(FileName):
    """

    see doc : https://conf1.ds.jdsu.net/wiki/display/MOBILE/Mobile+Tech+REST+API
    """

    product_specific = api_node.config['rest_api.product_specific']
    success = product_specific.process_firmware_upgrade_post(request, FileName)


    if success:
        response.status = 200
    else:
        response.status = 400


    return {}
