"""
Module containing endpoints for the job manager api
"""
from webargs.bottleparser import use_kwargs
from bottle import request, response, Bottle
from rest_api.schemas import DateTimeSchema

api_node = Bottle()  # pylint: disable=invalid-name
__api_version__ = 1
__api_name__ = "datetime"

@api_node.put('/api/v1/datetime')
@use_kwargs(DateTimeSchema(strict=True))
def set_time(time_value, location):
    """
    Endpoint to set the instrument's date and time

    Attributes:
        time_value(DateTime): Python DateTime object representation of the iso 8601
            compliant date/time string provided when a request is made to this endpoint.

        location(string): A string representation of the timezone (e.g. Americas/Los Angeles)
    ---
    put:
        tags:
          - settings
        description: Currently just dummy endpoint to facilitate mobile tech connectivity
        responses:
            200:
                description: Success
                'schema':
                    title: Instrument Time
                    type: object
            400:
                description: Bad Request
    """

    product_specific = api_node.config['rest_api.product_specific']
    success = product_specific.update_time(time_value, location)

    if not success:
        response.status = 404

    return {}
