init-puma_init()
{
    isPUMAUpdated[1]=-1
    isPUMAUpdated[2]=-1

    # PUMA management
    #
    # Search for HETNET modules in position 1 or 2 and look for a PUMA module
    for i in `seq 1 2`;
    do
    qdbus --literal --system com.viavisolutions.platform.SystemInventory /com/viavisolutions/platform/SystemInventory/$i com.viavisolutions.platform.SystemInventory.ModuleResources.SystemRecords | grep -q "702200B64-"
    if [ $? -eq 0 ]
    then
        echo "PUMA module found at address $i"

        # Program the PUMA Module's fpga if needed
        load_puma_fpga.sh ${i}
        isPUMAUpdated[$i]=$?
    fi
    done

    if   [[ "${isPUMAUpdated[1]}" -eq "0" ]] \
      || [[ "${isPUMAUpdated[2]}" -eq "0" ]]
    then
        echo "A PUMA module has been updated - Reboot in 5 seconds"

        # Simulate Otu launch to avoid rebooting in rescue mode - if script exists
        [ -f /sbin/otu_confirm_start.sh ] && otu_confirm_start.sh

        sleep 5

        reboot
        exit -1
    fi
}
