#! /usr/bin/python3
from PyPDF3 import PdfFileWriter, PdfFileReader

import sys

# USAGE:
# pdf_join.py <output_pdf_file> <input_pdf_file1> <input_pdf_file2> <input_pdf_file3> ...etc

if len(sys.argv) < 3:
    print('error - missing arguments.')
    sys.exit(1)

output = PdfFileWriter()

sys.argv.pop(0)
outputFilename = sys.argv.pop(0)

try:
    pdfList = list()

    for fileName in sys.argv:
        pdfReader = PdfFileReader(open(fileName, 'rb'))
        for page in range(pdfReader.getNumPages()):
            output.addPage(pdfReader.getPage(page))

        pdfList.append(pdfReader)

    outputStream = open(outputFilename , "wb")
    output.write(outputStream)
    outputStream.close()
except Exception as e:
    print(e)
    sys.exit(1)

sys.exit(0)
