#! /bin/sh

PUMA_BITSTREAM="/acterna/storage/fpga/u-boot-puma.bin"

Interface=1

# Process arguments
if [ $# -eq 1 ]
then
    Interface="$1"
else
    echo "ERROR: No PUMA Module selected"
    exit -1
fi

echo "PUMA #${Interface}"

# The SPI Connection with the PUMA module does not support the default
# clock speed used by advisordff (19 MHz) - We need to set it lower: 1 MHz is fine
export SPI_CLOCK_SPEED=1

# PUMA module and TACB are similar enough so that we can use the TACB command to flash the PUMA's FPGA
advisordff tacb -sf ${Interface} ${PUMA_BITSTREAM}
result=$?

# Reset the SPI clock speed
export -n SPI_CLOCK_SPEED
SPI_CLOCK_SPEED=

case $result in
    0)
    # 0  = Flash success - We need to reboot
    exit 0
    ;;

    11)
    # 11 = Already up to date - There is nothing to be done
    exit 1
    ;;

    *)
    echo "ERROR: FPGA flash failed"
    exit -2
    ;;
esac
