import QtQuick 2.3
import "./UtilUiQt/Viavi_Colors.js" as VColor

Item {
    id: setupLine
    
    property alias inputText: lineName.text
    property alias inputModel: choiceLine.model
    property bool isExclusive: false
    property bool isError: false
    
    width: parent.width
    height: 60
    
    // Signals
    signal selectValueChanged( int index );
    
    // property int boxWidth: 80
    property int boxWidth: ( ( width - headerContainer.width - 4 ) - ( choiceLine.count - 1 ) * 2 ) / choiceLine.count
    
    Rectangle {
        id: headerContainer
        color: "transparent"
        height: parent.height
        width: 150

        Text {
        	id: lineName
            anchors.fill: parent            
            color: VColor.cViaviColorBlack
            font.pixelSize: 18
            font .bold: true
            text: "N/A"
            clip: true
            wrapMode: Text.Wrap
            verticalAlignment: Text.AlignVCenter
        }
        
        Image {
        	id: imagedescription
            width: 20
            height: 20
            
            visible: isError
            
            cache: false
			   asynchronous: true
            
            anchors.right: parent.right
            anchors.rightMargin: 3
            anchors.verticalCenter: parent.verticalCenter
            
            source: "/acterna/storage/look-and-feel/generic/Warning_Wizard.png"
            fillMode: Image.PreserveAspectFit
        }
        
        /*
        Rectangle {
            id: separatorContainer
            
            height: parent.height
            width: 2
            
            anchors.right: parent.right
            anchors.verticalCenter: parent.verticalCenter
            
            color: VColor.cViaviColorLightGray2
        } */
    }

    Row {
        anchors.left: headerContainer.right
        anchors.leftMargin: 4

        height: parent.height

        spacing: 2

        Repeater {
            id: choiceLine
            delegate: Wizard_Setup_Message_Box_Values {
            	enabled: choiceLine.count > 1
            	width: boxWidth
            	}
        }
    }
}
