import QtQuick 2.3
import "ViaviStyle"

Dialog {
	id: popUpWarning
	


    property string clickToExitText: ""
    
    property alias inProgress: animationId.running
    
    property string warningType: "" // Error/Warning/Info/Progress

    property string pathErrorIcon: "/acterna/storage/look-and-feel/generic/Pop_Up_Icon_Error.png"
    property string pathWarningIcon: "/acterna/storage/look-and-feel/generic/Pop_Up_Icon_Warning.png"
    property string pathInfoIcon: "/acterna/storage/look-and-feel/generic/Pop_Up_Icon_Info.png"
    property string path_spin_img: "/acterna/storage/look-and-feel/generic/Busy_Wizard.png"

    property string typePath:{
        if(popUpWarning.warningType == "Info"){
            return pathInfoIcon
        } else if(popUpWarning.warningType == "Warning"){
            return pathWarningIcon
        } else if(popUpWarning.warningType == "Error"){
            return pathErrorIcon
        } else if(popUpWarning.warningType == "Progress"){
            return path_spin_img
        }

        return ""
    }

    RotationAnimation {
        id: animationId

        target: popUpWarning.imageItem
        property: "rotation"
        from: 0
        to: 360
        direction: RotationAnimation.Clockwise
        duration: ViaviStyle.waitingAnimationDuration
        loops: Animation.Infinite
    }

    exitText: clickToExitText
    iconSource: typePath
}
