import QtQuick 2.3
import QtQuick.Controls 2.0
import QtQuick.Layouts 1.2
import "ViaviStyle"

AbstractButton{
    id: button

    readonly property real opacityEnabled: 1
    readonly property real opacityDisabled: 0.5
    readonly property real opacityPressed: 0.8
    opacity: enabled ? pressed ? opacityPressed: opacityEnabled : opacityDisabled

    contentItem:
        Rectangle{
        anchors.fill: parent
        color: button.enabled ? ViaviStyle.colors.activeColor : ViaviStyle.colors.secondaryInfoColor

        Text{
            id: text
            anchors.fill: parent
            anchors.margins: ViaviStyle.layouts.smallMargin

            horizontalAlignment: Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter

            text: button.text
            font: ViaviStyle.layouts.veryLargeFont
            color: ViaviStyle.colors.activeItemTextColor
        }
    }
}
