import QtQuick 2.3
import "Viavi_Colors.js" as VColor
import libfexplor 1.0

FocusScope {
    id: id_root_rec

    property string colorCursor_Silder   :  VColor.cViaviColorGray //VColor.cViaviColorLogoPurple
    property int lineHeight : qmlFileItemList.get_height_screen() >=600 ? 30: 45

   Keys.forwardTo: id_File_Explorer_Tree //id_File_Explorer_Tree.focus  ? id_File_Explorer_Tree :  id_File_Explorer_List

   onVisibleChanged: {
       if (visible) {
           forceActiveFocus()
       }
   }

    File_Explorer_Tree {
        id:id_File_Explorer_Tree
        height       : id_root_rec.height
        anchors.left : id_root_rec.left
        anchors.right: rectCursor_Silder.left
    }


    File_Explorer_List {
        id:id_File_Explorer_List
        anchors.left: rectCursor_Silder.right
        height        : id_root_rec.height
        anchors.right : id_root_rec.right
    }


    Rectangle {
       // focus:true
        id: rectCursor_Silder
        width: 3;
        height: parent.height
        x:id_root_rec.width * 30/100
        color: colorCursor_Silder
        opacity: 1
        MouseArea {
            id:id_MouseArea_Cursor_Silder
            anchors.leftMargin:    0
            anchors.rightMargin:  -20
            anchors.bottomMargin: 0
            anchors.topMargin:   id_root_rec.lineHeight
            anchors.fill:  parent
            // hoverEnabled: true

            drag.target: rectCursor_Silder
            drag.axis: Drag.XAxis
            drag.minimumX: 0
            drag.maximumX: id_root_rec.width - rectCursor_Silder.width
            onReleased: {

                id_vertical_bar.color = "white"
                id_vertical_bar.width = 0
                rectCursor_Silder.color = colorCursor_Silder
            }

            onEntered:  {

                id_vertical_bar.color =  "white"
                id_vertical_bar.width = 1
                rectCursor_Silder.color = colorCursor_Silder
            }

            onPositionChanged: {

                id_vertical_bar.color = "white"
                id_vertical_bar.width = 1
                rectCursor_Silder.color =colorCursor_Silder
            }


            //            onHoveredChanged:  {

            //                console.log("containsMouse", containsMouse)

            //                if (id_MouseArea_Cursor_Silder.containsMouse == true)
            //                {

            //                    rectCursor_Silder.color = "steelblue"
            //                }
            //                else
            //                {

            //                    rectCursor_Silder.color = VColor.cViaviColorLightGray2
            //                }

            //            }

        }


        Rectangle {
            id:id_vertical_bar
            height: 200
            anchors.horizontalCenter: parent.horizontalCenter
            anchors.verticalCenter:  parent.verticalCenter
            width: 0
            color: "white"

        }
    }

}

