import QtQuick 2.3
import "./UtilUiQt/Viavi_Colors.js" as VColor

import "ViaviStyle"

Rectangle {
    id: pow_win

    Column {
        id: powColumn
        anchors.top: parent.top
        anchors.topMargin: ViaviStyle.layouts.mediumMargin
        anchors.left: parent.left
        anchors.leftMargin: ViaviStyle.layouts.largeMargin
        anchors.right: parent.right
        anchors.rightMargin: ViaviStyle.layouts.largeMargin

        height: parent.height * 0.6

        Pow_Pon_One {
            width: parent.width
            height: parent.height / 2
            pow_number : 1
        }

        Pow_Pon_One {
            width:  parent.width
            height: parent.height / 2
            pow_number : 2
        }
    }

    GenericTable {
        id: table
        anchors.top: powColumn.bottom
        anchors.topMargin: ViaviStyle.layouts.mediumMargin
        anchors.left: parent.left
        anchors.leftMargin: ViaviStyle.layouts.largeMargin
        anchors.right: parent.right
        anchors.rightMargin: ViaviStyle.layouts.largeMargin
        anchors.bottom: parent.bottom
        anchors.bottomMargin: ViaviStyle.layouts.mediumMargin

        titleAreaHeight: Math.max ( ViaviStyle.layouts.imageButtonHeight + 2 * ViaviStyle.layouts.smallMargin,
                                   2 * titleCellHeight )

        Row {
            anchors.top: parent.top
            anchors.topMargin: ViaviStyle.layouts.smallMargin
            anchors.right: parent.right
            anchors.rightMargin: ViaviStyle.layouts.largeMargin

            spacing: 2 * ViaviStyle.layouts.largeMargin

            FiberColorImage {
                height: ViaviStyle.layouts.imageButtonHeight
                width: height * 1.4

                fillMode: Image.PreserveAspectFit
                source: ViaviStyle.images.keepResultsIconPath
                opacity: button.pressed ? 0.6 : 1

                MouseArea {
                    id: button
                    anchors.fill: parent
                    onClicked:{
                        numericdisplay_act_ponKeepResults.invoke()
                    }
                }
            }

            FiberImageButton {
                source: ViaviStyle.images.deleteIcon
                onClicked:{
                    numericdisplay_act_ponClearResults.invoke()
                }
            }
        }
    }
}

