import QtQuick 2.3
import QtQuick.Layouts 1.2
import QtQuick.Controls 2.0

import "ViaviStyle"

Popup
{
    id: root

    width: parent.width
    height: parent.height

    background: Rectangle{

        anchors.fill: parent

        color: ViaviStyle.colors.transparentBackgroundColor

        MouseArea{
            anchors.fill: parent

            onClicked: {

            }
        }
    }

    FiberContainer{
        anchors.fill: parent
        anchors.margins: ViaviStyle.layouts.veryLargeMargin

        ColumnLayout{
            id: mainArea
            anchors.fill: parent
            anchors.margins: ViaviStyle.layouts.mediumMargin

            property bool osaSNRColumnVisible: osaGrid_res_osaSNRHeader.value !== ""

            property real nrOfCells: osaSNRColumnVisible ? 8 : 7

            //indexCellWidth + nrOfCells * cellWidth will be width. the forumla ensures that cellWidth = 2 * indexCellWidth
            property real indexCellWidth: width / ((nrOfCells - 1) * 2 + 1)
            property real cellWidth: 2 * indexCellWidth

            Item {

                Layout.fillWidth: true

                height: ViaviStyle.layouts.buttonHeight

                FiberButton{
                    height: ViaviStyle.layouts.buttonHeight

                    width: parent.width / 4
                    text: osaGrid_res_inverseGridText.value
                    anchors.left: parent.left

                    visible: osaGrid_res_gridType.enums.ecGrid_Manual == osaGrid_res_gridType.value

                    onClicked:{
                        osaGrid_act_inverseGrid.invoke()
                    }
                }

                FiberImageButton{
                    id: button

                    anchors.right: parent.right

                    source: ViaviStyle.images.closeButtonIcon

                    onClicked:{
                        osaGrid_act_closeGrid.invoke()
                    }
                }
            }

            TableHeaderRow{
                TableHeaderCell{
                    width: mainArea.indexCellWidth
                    valueTextHorizontalAllignment: Text.AlignHCenter
                    valueTextVerticalAlignment: Text.AlignVCenter
                    valueText: osaGrid_res_numberHeader.value
                }
                TableHeaderCell{
                    width:  mainArea.cellWidth
                    valueTextHorizontalAllignment: Text.AlignHCenter
                    valueTextVerticalAlignment: Text.AlignVCenter
                    valueText: osaGrid_res_bandIdHeader.value
                }
                TableHeaderCell{
                    width:  mainArea.cellWidth
                    valueTextHorizontalAllignment: Text.AlignHCenter
                    valueTextVerticalAlignment: Text.AlignVCenter
                    valueText: osaGrid_res_channelIdHeader.value
                }
                TableHeaderCell{
                    width:  mainArea.cellWidth
                    valueTextHorizontalAllignment: Text.AlignHCenter
                    valueTextVerticalAlignment: Text.AlignVCenter
                    valueText: osaGrid_res_osaRefHeader.value
                }
                TableHeaderCell{
                    width: mainArea.cellWidth
                    valueTextHorizontalAllignment: Text.AlignHCenter
                    valueTextVerticalAlignment: Text.AlignVCenter
                    valueText: osaGrid_res_osaDeltaHeader.value
                }
                TableHeaderCell{
                    width: mainArea.cellWidth
                    valueTextHorizontalAllignment: Text.AlignHCenter
                    valueTextVerticalAlignment: Text.AlignVCenter
                    valueText: osaGrid_res_osaPMinHeader.value
                }
                TableHeaderCell{
                    width: mainArea.cellWidth
                    valueTextHorizontalAllignment: Text.AlignHCenter
                    valueTextVerticalAlignment: Text.AlignVCenter
                    valueText: osaGrid_res_osaPMaxHeader.value
                }
                TableHeaderCell{
                    width: visible ? mainArea.cellWidth : 0
                    valueTextHorizontalAllignment: Text.AlignHCenter
                    valueTextVerticalAlignment: Text.AlignVCenter
                    valueText: osaGrid_res_osaSNRHeader.value
                    visible: mainArea.osaSNRColumnVisible
                }
            }

            ListView {
                id: list
                Layout.fillWidth: true
                Layout.fillHeight: true

                boundsBehavior: Flickable.OvershootBounds
                clip: true
                model: osaGrid_res_osaGridTable.value



                delegate: TableRow {
                    id: row
                    TableTextCell{
                        id: indexCell
                        width: mainArea.indexCellWidth
                        valueTextHorizontalAllignment: Text.AlignHCenter
                        valueTextVerticalAlignment: Text.AlignVCenter
                        valueText: indexNr
                    }

                    FiberEditableText{
                        font: ViaviStyle.layouts.tableFont
                        width: mainArea.cellWidth
                        textHorizontalAlignment: Text.AlignHCenter
                        text: bandId

                        height: ViaviStyle.layouts.menuLineHeight

                        onClicked: {
                            osaGrid_act_changeBandId.invokeWithStringArg(index)
                        }
                    }

                    FiberEditableText{
                        font: ViaviStyle.layouts.tableFont
                        width: mainArea.cellWidth
                        textHorizontalAlignment: Text.AlignHCenter
                        text: channelId

                        height: ViaviStyle.layouts.menuLineHeight

                        onClicked: {
                            osaGrid_act_changeChannelId.invokeWithStringArg(index)
                        }
                    }

                    FiberEditableText{
                        id: editableOsaRef
                        font: ViaviStyle.layouts.tableFont
                        width: visible ? mainArea.cellWidth : 0
                        textHorizontalAlignment: Text.AlignHCenter
                        text: osaRef

                        height: ViaviStyle.layouts.menuLineHeight

                        visible: osaGrid_res_gridType.enums.ecGrid_Manual == osaGrid_res_gridType.value

                        onClicked: {
                            osaGrid_act_changeRef.invokeWithStringArg(index)
                        }
                    }

                    TableTextCell{
                        width: visible ? mainArea.cellWidth : 0
                        valueTextHorizontalAllignment: Text.AlignHCenter
                        valueTextVerticalAlignment: Text.AlignVCenter
                        valueText: osaRef

                        visible: !editableOsaRef.visible
                    }

                    TableTextCell{
                        width: mainArea.cellWidth
                        valueTextHorizontalAllignment: Text.AlignHCenter
                        valueTextVerticalAlignment: Text.AlignVCenter
                        valueText: osaDelta
                    }

                    TableTextCell{
                        width: mainArea.cellWidth
                        valueTextHorizontalAllignment: Text.AlignHCenter
                        valueTextVerticalAlignment: Text.AlignVCenter
                        valueText: osaPMin
                    }

                    TableTextCell{
                        width: mainArea.cellWidth
                        valueTextHorizontalAllignment: Text.AlignHCenter
                        valueTextVerticalAlignment: Text.AlignVCenter
                        valueText: osaPMax
                    }

                    TableTextCell{
                        width: visible ? mainArea.cellWidth : 0
                        valueTextHorizontalAllignment: Text.AlignHCenter
                        valueTextVerticalAlignment: Text.AlignVCenter
                        valueText: osaSNR
                        visible: mainArea.osaSNRColumnVisible
                    }
                }
            }
        }
    }


}
