import QtQuick 2.3

Loader {
    id: localeLayout
    source: getLayoutPath(layoutName)
    property string layoutName: defaultLayoutName
    property var layouts: layouts
    readonly property string defaultLayoutName: layouts.get(0).name

    function getLayoutPath(name) {
        var layout = find(layouts, function(item) { return item.name === name })
        if (layout) {
            return layout.path
        }
        else {
            return null
        }
    }

    function find(model, criteria) {
        for (var i = 0; i < model.count; i++) {
            if (criteria(model.get(i))) {
                return model.get(i)
            }
        }
        return null
    }

    //Property 'name' is to be kept in sync with getKeyboardLayoutEnum()
    //Values such as keyboard_cfg_keyboardLayout.enums.ecEnglish_Language cannot be used though ListElement: cannot use script for property value
    ListModel {
        id: layouts
        ListElement {
            displayName: 'English'
            name: 'en_EN'
            path: 'layouts/EN_GB_main.qml'
        }
        ListElement {
            displayName: 'Français'
            name: 'fr_FR'
            path: 'layouts/FR_FR_main.qml'
        }
        ListElement {
            displayName: 'Deutsch'
            name: 'de_DE'
            path: 'layouts/DE_DE_main.qml'
        }
        //Enable the below list elements as the respective layout files are created
        /**
        ListElement {
            displayName: 'Español'
            name: 'es_ES'
            path: 'layouts/DE_DE_main.qml'
        }
        ListElement {
            displayName: 'Italiano'
            name: 'it_IT'
            path: 'layouts/DE_DE_main.qml'
        }
        ListElement {
            displayName: 'Português'
            name: 'pt_PT'
            path: 'layouts/DE_DE_main.qml'
            enabled: false
        }
        ListElement {
            displayName: '繁體中文'
            name: 'zh_TW'
            path: 'layouts/DE_DE_main.qml'
        }
        ListElement {
            displayName: '中文'
            name: 'zh_CN'
            path: 'layouts/DE_DE_main.qml'
        }
        ListElement {
            displayName: '日本語'
            name: 'ja_JP'
            path: 'layouts/DE_DE_main.qml'
        }
        ListElement {
            displayName: 'Русский'
            name: 'ru_RU'
            path: 'layouts/DE_DE_main.qml'
        }
        ListElement {
            displayName: '한국어'
            name: 'ko_KR'
            path: 'layouts/DE_DE_main.qml'
        }
        ListElement {
            displayName: 'Türkçe'
            name: 'ru_RU'
            path: 'layouts/DE_DE_main.qml'
        }
        ListElement {
            displayName: 'Svenska'
            name: 'sv_SE'
            path: 'layouts/DE_DE_main.qml'
        }
        ListElement {
            displayName: 'Norsk'
            name: 'nb_NO'
            path: 'layouts/DE_DE_main.qml'
        }
        ListElement {
            displayName: 'čeština'
            name: 'cs_CZ'
            path: 'layouts/DE_DE_main.qml'
        }
        ListElement {
            displayName: 'Magyar'
            name: 'hu_HU'
            path: 'layouts/DE_DE_main.qml'
        }
        ListElement {
            displayName: 'Polski'
            name: 'pl_PL'
            path: 'layouts/DE_DE_main.qml'
        }
        ListElement {
            displayName: 'Suomi'
            name: 'fi_FI'
            path: 'layouts/DE_DE_main.qml'
        }
        ListElement {
            displayName: 'Danske'
            name: 'da_DK'
            path: 'layouts/DE_DE_main.qml'
        }
        ListElement {
            displayName: 'Việt Nam'
            name: 'vi_VN'
            path: 'layouts/DE_DE_main.qml'
        }
        ListElement {
            displayName: 'Bahasa Indonesia'
            name: 'id_ID'
            path: 'layouts/DE_DE_main.qml'
        }
        /**/
    }
}
