import QtQuick 2.5
import "ViaviStyle"

KeyboardNumerical{

    minValue: keyboard_res_minValue.value
    maxValue: keyboard_res_maxValue.value
    autoValue: keyboard_res_autoValue.value

    minValueString: keyboard_res_minString.value
    maxValueString: keyboard_res_maxString.value

    titleDescription: keyboard_res_titleDescription.value

    titleText: keyboard_res_title.value
    hasTitleAction: keyboard_res_hasTitleCallback.value
    onTitleClicked: {
        keyboard_act_handleTitleCallback.invoke()
    }

    inputTextMaxLength: keyboard_res_maxSize.value

    onInputTextChanged: keyboard_cfg_text.value = newText


    configurableButtonPicturePath: keyboard_res_hasMeasureButton.value ?
                                       keyboardUtils.buttonIconPath + "Icon_Measure.png"
                                     : ""

    initialText: keyboard_res_initText.value

    hasDefaultButton: keyboard_res_hasDefaultButton.value

    onCanceled: {
        keyboard_act_handleCancelKey.invoke()
    }

    onAccepted: {
        keyboard_act_handleEnterKey.invoke()
    }

    onConfigurableButtonClicked:{
       keyboard_act_handleMeasureKey.invoke()
    }

    ListModel{
        id: legacyModel
    }

    alternativeKeysModel: legacyModel

    function updateModel(){
        legacyModel.clear()
        for(var index = 0; index < keyboard_res_buttons_stringARRAY.valueCount; ++index){
           legacyModel.append({"name": keyboard_res_buttons_stringARRAY.at(index)})
        }
    }

    Component.onCompleted: updateModel()

    Connections{
        target: keyboard_res_buttons_stringARRAY
        onValueChanged: updateModel()
    }
}
