import QtQuick 2.5
import QtQuick.Controls 2.0
import QtQuick.Window 2.2
import "ViaviStyle"

Popup {
    id: keyboard

    //Popup closing passes focus back to parent, but in Fiber the caller is generally not a parent, e.g. file manager, menus.
    property var previousFocus: null
    onAboutToShow: {
        previousFocus = keyboard.parent.Window.window.activeFocusItem
    }
    onAboutToHide: {
        if (previousFocus) {
            previousFocus.forceActiveFocus()
        }
    }

    KeyboardUtils { id: keyboardUtils }

    width: parent.width
    height: parent.height
    x:0
    y:0

    background: Rectangle{

        anchors.fill: parent

        color: ViaviStyle.colors.transparentBackgroundColor
    }

    modal: true

    closePolicy: Popup.NoAutoClose

    contentItem: Item{

        anchors.fill: parent

        LegacyKeyboardNumerical {
            visible: keyboard_res_type.value === keyboard_res_keyboardType.enums.ecNum_Keyboard
                        || keyboard_res_type.value === keyboard_res_keyboardType.enums.ecDate_Time_Keyboard

        }

        LegacyKeyboardAlpha {
            visible:    ( keyboard_res_type.value === keyboard_res_keyboardType.enums.ecFile_Name_Keyboard
                       || keyboard_res_type.value === keyboard_res_keyboardType.enums.ecComplete_Keyboard
                       || keyboard_res_type.value === keyboard_res_keyboardType.enums.ecAuto_File_Name_Keyboard
                       || keyboard_res_type.value === keyboard_res_keyboardType.enums.ecAuto_Dir_Name_Keyboard )

        }
    }
}

