import QtQuick 2.3

Rectangle {
	id: dialog

	Image {
		width: parent.width
		height: parent.height
		source: Dial.background

		Rectangle {
			color: "transparent"
			width: 100
			height: parent.height
			anchors.left: parent.left

			Image {
				anchors.centerIn: parent
				fillMode: Image.PreserveAspectFit
				width: 35
				height: 53
				source: Dial.icon
			}
		}

		Image {
			anchors.verticalCenter: parent.verticalCenter
			anchors.right: parent.right
			width: 100
			height: 1
			source: Dial.underline
		}
	}

	Rectangle {
		color: "transparent"
		anchors.top: parent.top
		x: 100

		width: parent.width - 200
		height: parent.height

		Text {
			anchors.fill: parent
			verticalAlignment: Text.AlignVCenter

			font.family: "DejaVu LGC SansCondensed"
			font.bold: false
			font.pointSize: 16

			text: Dial.label
		}
	}


	Rectangle {
		color: "transparent"
		anchors.top: parent.top
		anchors.right: parent.right
		width: 100
		height: parent.height / 2

		Text {
			anchors.fill: parent
			verticalAlignment: Text.AlignVCenter
			horizontalAlignment: Text.AlignHCenter

			font.family: "DejaVu LGC SansCondensed"
			font.bold: false
			font.pointSize: 16

			text: "Ok"
		}

		MouseArea {
			anchors.fill: parent
			onClicked: {
				Dial.closeDialogOk();
			}
		}
	}

	Rectangle {
		color: "transparent"
		anchors.bottom: parent.bottom
		anchors.right: parent.right
		width: 100
		height: parent.height / 2

		Text {
			anchors.fill: parent
			verticalAlignment: Text.AlignVCenter
			horizontalAlignment: Text.AlignHCenter

			font.family: "DejaVu LGC SansCondensed"
			font.bold: false
			font.pointSize: 16

			text: "Cancel"
		}

		MouseArea {
			anchors.fill: parent
			onClicked: {
				Dial.closeDialogCancel();
			}
		}
	}
}

