import QtQuick 2.3
import QtQuick.Layouts 1.2

import "./GenericTableUtils.js" as TableUtils

import "ViaviStyle"

Rectangle {
    id: container
    color: ViaviStyle.colors.contentBackgroundColor
    clip: true

    property bool init: false

    property int gridWidth: width
    property int cellHeight: ViaviStyle.layouts.genericTableLineHeight

    property string emptyCellText: "--"

    property Component selectedOverlay: null

    property alias eventPopupAlias: eventPopup
    
    property bool bDraw_Active_Line: generictable_res_bIsDrawActiveLine.value
    property bool isDisplay_Info_Button_Available: false

    function get_text_color ( status, isSelected ){
        return isSelected && ViaviStyle.colors.getTextColor( status ) === ViaviStyle.colors.mainInfoColor
                ? ViaviStyle.colors.activeItemTextColor : ViaviStyle.colors.getTextColor( status );
    }

    function selectLine( index )
    {
        generictable_act_cellPress.invokeWithStringArg(index)
    }

    //
    // Note that the popup cannot be a child of a grid element because they are reconstructed on various events.
    //When a grid element is destroyed, its children are also destroyed, thus also closing the poup
    //
    //TODO: this FiberPopup does not apply to all GenericTableGridData. Move it outside, and also make the PopupMouseArea conditional
    EventTypePopup {
        id: eventTypePopup
        overlayReplacer: getFiberMainPage()
    }

    FiberPopup {
        id: eventPopup

        property bool deleteButtonVisible: misc_res_addEventState.value === misc_res_addEventState.enums.ecKey_Color_Normal
        FiberToolButton {
            id: deleteButton
            text: eventscontrol_res_deleteEventLabel.value
            visible: eventPopup.deleteButtonVisible
            onClicked: {
                misc_act_addEvent.invoke()
                eventPopup.close()
            }
        }

        property bool changeTypeButtonVisible: eventscontrol_res_eventCodeVisible.value
        FiberToolButton {
            id: changeTypeButton
            text: eventscontrol_res_eventCodeLabel.value
            visible: eventPopup.changeTypeButtonVisible

            onClicked: {
                eventTypePopup.x = eventPopup.x
                eventTypePopup.y = eventPopup.y
                eventTypePopup.open()
                eventPopup.close()
            }
        }

        property bool addNoteButtonVisible: eventscontrol_res_noteVisible.value
        FiberToolButton {
            id: addNoteButton
            text: eventscontrol_res_addNoteLabel.value
            visible: eventPopup.addNoteButtonVisible
            onClicked: {
                eventscontrol_act_addNoteToEvent.invoke()
                eventPopup.close()
            }
        }

        function haveButtonsVisible() {
            var buttonsVisible = deleteButtonVisible || changeTypeButtonVisible || addNoteButtonVisible
            return buttonsVisible
        }
    }

    Component{
        id: cellItemComponent

        GenericTableCell {
            isIcon: modelCellIcon !== ""
            cellWidth: modelCellWidth
            height: cellHeight
            textColor: container.get_text_color( modelCellStatus, modelCellIsSelected)
            textDisplay: isIcon ? modelCellIcon : modelCellText
            textAlignment: modelCellAllignment
            isSelected: modelCellIsSelected
            isIconManual: isIcon ? modelCellIsIconManual: false
            emptyCellText: container.emptyCellText
            row: modelCellRow
            column: modelCellColumn
            alarmStatus: modelCellStatus
            isDisplay_Info_Available: isDisplay_Info_Button_Available
        }
    }

    ListView{
        id: listViewId

        anchors.fill: parent

        //the generic table can become very small, dragging will be difficult because the touch event leaves the flickable area too easilly thus canceling it
        //this way the flickable area become larger than the visible area and the touch zone increases, allowing a better dragging experience
        //dummy empty items need to be added to the conntent of the item so that all table rows are allways accessible: topExtra, bottomExtra
        anchors.topMargin: -extraTouchArea
        anchors.bottomMargin: -extraTouchArea

        cacheBuffer: 0

        property int extraTouchArea: ViaviStyle.layouts.genericTableLineHeight

        currentIndex: generictable_res_currentIndex.value

        flickableDirection: Flickable.VerticalFlick
        boundsBehavior: Flickable.StopAtBounds

        onHeightChanged: triggerSelectItemRepsition()

        function triggerSelectItemRepsition(){
            repositionSelectedItemTimer.restart()
        }

        //don't use directly this function. use triggerSelectItemRepsition
        //there can be a variable number of events that can trigger the need for reposition and only the last needs to be proccesed
        function selectedItemReposition(){
            if(generictable_res_currentIndex.value !== -1 && currentItem){
                if(currentItem.y + currentItem.height - currentItem.extraBottom > contentY + height - listViewId.extraTouchArea){
                    contentY = Math.max(0, Math.min(contentHeight - currentItem.height, currentItem.y + currentItem.height - currentItem.extraBottom - height + listViewId.extraTouchArea))
                }
                if(currentItem.y < contentY + listViewId.extraTouchArea){
                    contentY = Math.max(0, Math.min(contentHeight - currentItem.height, currentItem.y - listViewId.extraTouchArea))
                }
            }
        }

        onVisibleChanged: {
            if(visible){
                triggerSelectItemRepsition()
            }
        }

        onCurrentItemChanged: triggerSelectItemRepsition()

        Timer {
            id: repositionSelectedItemTimer

            interval: 50

            onTriggered: listViewId.selectedItemReposition()
        }

        model: generictable_res_tableElementList.value

        delegate:Item{
            id: delegateId

            property var listModel: model

            property bool isSelected: generictable_res_currentIndex.value === delegateId.listModel.index


            property int extraTop: model.index === 0 ? listViewId.extraTouchArea : 0
            property int extraBottom: (model.index === listViewId.count - 1) ? listViewId.extraTouchArea : 0
            width: columnId.width
            height: columnId.height + extraTop + extraBottom

            Loader{

                active: delegateId.isSelected

                anchors.fill: columnId

                sourceComponent: Component{
                    Rectangle{


                        color: ViaviStyle.colors.activeColor
                    }
                }
            }

            Column{
                id: columnId

                y: extraTop

                Row{
                    id: rowId

                    spacing: 0

                    Loader{
                        sourceComponent: cellItemComponent

                        active: modelCellWidth > 0

                        property int modelCellWidth: generictable_res_dataColWidth_0.value * container.gridWidth /100
                        property int modelCellAllignment: generictable_res_dataColAlignment_0.value
                        property int modelCellStatus: listModel.elementStatus0
                        property string modelCellIcon: listModel.elementIcon0
                        property string modelCellText: listModel.elementText0
                        property bool modelCellIsSelected: delegateId.isSelected
                        property bool modelCellIsIconManual: listModel.elementIsIconManual
                        property int modelCellColumn: 0
                        property int modelCellRow: model.index
                    }

                    Item{

                        width: generictable_res_dataColWidth_1.value * container.gridWidth /100
                        height: cellHeight
                        Loader{
                            id: column1
                            sourceComponent: cellItemComponent

                            active: modelCellWidth > 0

                            property int modelCellWidth: generictable_res_dataColWidth_1.value * container.gridWidth /100
                            property int modelCellAllignment: generictable_res_dataColAlignment_1.value
                            property int modelCellStatus: listModel.elementStatus1
                            property string modelCellIcon: listModel.elementIcon1
                            property string modelCellText: listModel.elementText1
                            property bool modelCellIsSelected: delegateId.isSelected
                            property bool modelCellIsIconManual: listModel.elementIsIconManual
                            property int modelCellColumn: 1
                            property int modelCellRow: model.index
                          }

                        // Indicator image displayed on top of eventIcon
                        Loader {
                            anchors.fill: parent
                            anchors.margins: ViaviStyle.layouts.isSmallScreen ? ViaviStyle.layouts.mediumMargin / 2 : 0

                            active: listModel.elementIconIndicator !== ""
                            sourceComponent: Image {
                                source: listModel.elementIconIndicator
                                fillMode: Image.PreserveAspectFit
                                smooth: true
                            }
                        }

                        Item{
                            anchors.fill: parent

                            Rectangle{
                                anchors.left: parent.left
                                anchors.top: parent.top
                                anchors.bottom: parent.bottom

                                width: ViaviStyle.layouts.borderSize

                                color: delegateId.isSelected ? ViaviStyle.colors.borderColor : ViaviStyle.colors.borderColor

                                visible: model.groupElementType !== schematic_res_groupElementTypeEnum.enums.egetNone
                            }

                            Rectangle{
                                anchors.right: parent.right
                                anchors.top: parent.top
                                anchors.bottom: parent.bottom

                                width: ViaviStyle.layouts.borderSize

                                color: delegateId.isSelected ? ViaviStyle.colors.borderColor : ViaviStyle.colors.borderColor

                                visible: model.groupElementType !== schematic_res_groupElementTypeEnum.enums.egetNone
                            }

                            Rectangle{
                                anchors.right: parent.right
                                anchors.left: parent.left
                                anchors.top: parent.top

                                height: ViaviStyle.layouts.borderSize

                                color: delegateId.isSelected ? ViaviStyle.colors.borderColor : ViaviStyle.colors.borderColor

                                visible: model.groupElementType === schematic_res_groupElementTypeEnum.enums.egetBegin
                            }
                            Rectangle{
                                anchors.right: parent.right
                                anchors.left: parent.left
                                anchors.bottom: parent.bottom

                                height: ViaviStyle.layouts.borderSize

                                color: delegateId.isSelected ? ViaviStyle.colors.borderColor : ViaviStyle.colors.borderColor

                                visible: model.groupElementType === schematic_res_groupElementTypeEnum.enums.egetEnd
                            }
                        }
                    }



                    Loader{
                        sourceComponent: cellItemComponent

                        active: modelCellWidth > 0

                        property int modelCellWidth: generictable_res_dataColWidth_2.value * container.gridWidth /100
                        property int modelCellAllignment: generictable_res_dataColAlignment_2.value
                        property int modelCellStatus: listModel.elementStatus2
                        property string modelCellIcon: listModel.elementIcon2
                        property string modelCellText: listModel.elementText2
                        property bool modelCellIsSelected: delegateId.isSelected
                        property bool modelCellIsIconManual: listModel.elementIsIconManual
                        property int modelCellColumn: 2
                        property int modelCellRow: model.index
                    }

                    Loader{
                        sourceComponent: cellItemComponent

                        active: modelCellWidth > 0

                        property int modelCellWidth: generictable_res_dataColWidth_3.value * container.gridWidth /100
                        property int modelCellAllignment: generictable_res_dataColAlignment_3.value
                        property int modelCellStatus: listModel.elementStatus3
                        property string modelCellIcon: listModel.elementIcon3
                        property string modelCellText: listModel.elementText3
                        property bool modelCellIsSelected: delegateId.isSelected
                        property bool modelCellIsIconManual: listModel.elementIsIconManual
                        property int modelCellColumn: 3
                        property int modelCellRow: model.index
                    }

                    Loader{
                        sourceComponent: cellItemComponent

                        active: modelCellWidth > 0

                        property int modelCellWidth: generictable_res_dataColWidth_4.value * container.gridWidth /100
                        property int modelCellAllignment: generictable_res_dataColAlignment_4.value
                        property int modelCellStatus: listModel.elementStatus4
                        property string modelCellIcon: listModel.elementIcon4
                        property string modelCellText: listModel.elementText4
                        property bool modelCellIsSelected: delegateId.isSelected
                        property bool modelCellIsIconManual: listModel.elementIsIconManual
                        property int modelCellColumn: 4
                        property int modelCellRow: model.index
                    }

                    Loader{
                        sourceComponent: cellItemComponent

                        active: modelCellWidth > 0

                        property int modelCellWidth: generictable_res_dataColWidth_5.value * container.gridWidth /100
                        property int modelCellAllignment: generictable_res_dataColAlignment_5.value
                        property int modelCellStatus: listModel.elementStatus5
                        property string modelCellIcon: listModel.elementIcon5
                        property string modelCellText: listModel.elementText5
                        property bool modelCellIsSelected: delegateId.isSelected
                        property bool modelCellIsIconManual: listModel.elementIsIconManual
                        property int modelCellColumn: 5
                        property int modelCellRow: model.index
                    }

                    Loader{
                        sourceComponent: cellItemComponent

                        active: modelCellWidth > 0

                        property int modelCellWidth: generictable_res_dataColWidth_6.value * container.gridWidth /100
                        property int modelCellAllignment: generictable_res_dataColAlignment_6.value
                        property int modelCellStatus: listModel.elementStatus6
                        property string modelCellIcon: listModel.elementIcon6
                        property string modelCellText: listModel.elementText6
                        property bool modelCellIsSelected: delegateId.isSelected
                        property bool modelCellIsIconManual: listModel.elementIsIconManual
                        property int modelCellColumn: 6
                        property int modelCellRow: model.index
                    }

                    Loader{
                        sourceComponent: cellItemComponent

                        active: modelCellWidth > 0

                        property int modelCellWidth: generictable_res_dataColWidth_7.value * container.gridWidth /100
                        property int modelCellAllignment: generictable_res_dataColAlignment_7.value
                        property int modelCellStatus: listModel.elementStatus7
                        property string modelCellIcon: listModel.elementIcon7
                        property string modelCellText: listModel.elementText7
                        property bool modelCellIsSelected: delegateId.isSelected
                        property bool modelCellIsIconManual: listModel.elementIsIconManual
                        property int modelCellColumn: 7
                        property int modelCellRow: model.index
                    }

                    Loader{
                        sourceComponent: cellItemComponent

                        active: modelCellWidth > 0

                        property int modelCellWidth: generictable_res_dataColWidth_8.value * container.gridWidth /100
                        property int modelCellAllignment: generictable_res_dataColAlignment_8.value
                        property int modelCellStatus: listModel.elementStatus8
                        property string modelCellIcon: listModel.elementIcon8
                        property string modelCellText: listModel.elementText8
                        property bool modelCellIsSelected: delegateId.isSelected
                        property bool modelCellIsIconManual: listModel.elementIsIconManual
                        property int modelCellColumn: 8
                        property int modelCellRow: model.index
                    }

                    Loader{
                        sourceComponent: cellItemComponent

                        active: modelCellWidth > 0

                        property int modelCellWidth: generictable_res_dataColWidth_9.value * container.gridWidth /100
                        property int modelCellAllignment: generictable_res_dataColAlignment_9.value
                        property int modelCellStatus: listModel.elementStatus9
                        property string modelCellIcon: listModel.elementIcon9
                        property string modelCellText: listModel.elementText9
                        property bool modelCellIsSelected: delegateId.isSelected
                        property bool modelCellIsIconManual: listModel.elementIsIconManual
                        property int modelCellColumn: 9
                        property int modelCellRow: model.index
                    }

                    Loader{
                        sourceComponent: cellItemComponent

                        active: modelCellWidth > 0

                        property int modelCellWidth: generictable_res_dataColWidth_10.value * container.gridWidth /100
                        property int modelCellAllignment: generictable_res_dataColAlignment_10.value
                        property int modelCellStatus: listModel.elementStatus10
                        property string modelCellIcon: listModel.elementIcon10
                        property string modelCellText: listModel.elementText10
                        property bool modelCellIsSelected: delegateId.isSelected
                        property bool modelCellIsIconManual: listModel.elementIsIconManual
                        property int modelCellColumn: 10
                        property int modelCellRow: model.index
                    }

                    Loader{
                        sourceComponent: cellItemComponent

                        active: modelCellWidth > 0

                        property int modelCellWidth: generictable_res_dataColWidth_11.value * container.gridWidth /100
                        property int modelCellAllignment: generictable_res_dataColAlignment_11.value
                        property int modelCellStatus: listModel.elementStatus11
                        property string modelCellIcon: listModel.elementIcon11
                        property string modelCellText: listModel.elementText11
                        property bool modelCellIsSelected: delegateId.isSelected
                        property bool modelCellIsIconManual: listModel.elementIsIconManual
                        property int modelCellColumn: 11
                        property int modelCellRow: model.index
                    }

                    Loader{
                        sourceComponent: cellItemComponent

                        active: modelCellWidth > 0

                        property int modelCellWidth: generictable_res_dataColWidth_12.value * container.gridWidth /100
                        property int modelCellAllignment: generictable_res_dataColAlignment_12.value
                        property int modelCellStatus: listModel.elementStatus12
                        property string modelCellIcon: listModel.elementIcon12
                        property string modelCellText: listModel.elementText12
                        property bool modelCellIsSelected: delegateId.isSelected
                        property bool modelCellIsIconManual: listModel.elementIsIconManual
                        property int modelCellColumn: 12
                        property int modelCellRow: model.index
                    }
                }

                Loader{
                    active: delegateId.listModel.elementNote !== ""

                    sourceComponent: Component{
                        Text{
                            width: rowId.width
                            height: contentHeight
                            wrapMode: Text.Wrap
                            text: delegateId.listModel.elementNote
                            font: ViaviStyle.layouts.tableFont
                            color: delegateId.isSelected ? ViaviStyle.colors.activeItemTextColor : ViaviStyle.colors.mainInfoColor
                        }
                    }
                }
            }

            PopupMouseArea {
                visible: bDraw_Active_Line
                anchors.fill: columnId
                z: parent.z + 1
                longPressMenu: container.eventPopupAlias.haveButtonsVisible() ? container.eventPopupAlias : null

                onBeforePressAndHold: {
                    container.selectLine(delegateId.listModel.index)
                }

                onClicked: {
                    container.selectLine( delegateId.listModel.index );
                }
            }
        }
    }
}

