import QtQuick 2.3
import QtQuick.Layouts 1.2

import "ViaviStyle"

FiberContainer {
    id: container

    property Component selectedOverlay: null
    property int gridWidth: mainArea.width
    property alias mainAreaWidth: mainArea.width
    property alias titleFont: gridTitle.titleFont
    property alias titleAreaHeight: gridTitle.height
    property alias titleBackgroundColor: gridTitle.color

    clip: true

    property int titleCellHeight: ViaviStyle.layouts.genericTableLineHeight
    property int headerCellHeight: ViaviStyle.layouts.genericTableLineHeight
    property int dataCellHeight: ViaviStyle.layouts.genericTableLineHeight

    property alias emptyCellText: gridData.emptyCellText
    
    property bool isInfo_Button_Available: false

	Rectangle {
        id: mainArea
		anchors.fill: parent
		anchors.margins: 2
		
		GenericTableGridTitle {
	    	id: gridTitle
	    	
            height: generictable_res_genericTableNbLineUpperTable.value * titleCellHeight
            cellHeight: titleCellHeight
            gridWidth: container.gridWidth
	    	
	    	anchors.top: parent.top
	    	anchors.left : parent.left
	        anchors.right : parent.right
	    }
		
		GenericTableGridHeader {
	    	id: gridHeader
	    	
            height: generictable_res_genericTableNbLineHeader.value * headerCellHeight
            cellHeight: headerCellHeight
            gridWidth: container.gridWidth
	    	
	    	anchors.top: gridTitle.bottom
	    	anchors.left : parent.left
	        anchors.right : parent.right
	    }
		
	    GenericTableGridData {
	    	id: gridData
	    	
            selectedOverlay: container.selectedOverlay

            cellHeight: dataCellHeight
            gridWidth: container.gridWidth

	    	anchors.top: gridHeader.bottom
	    	anchors.bottom: parent.bottom
	    	anchors.left : parent.left
	        anchors.right : parent.right
	        
	        isDisplay_Info_Button_Available: isInfo_Button_Available
	        
	    }
    }
}

