import QtQuick 2.3
import QtQuick.Controls 2.0
import "ViaviStyle"

AbstractButton{
    id: button
    
    property alias textHorizontalAlignment: text.horizontalAlignment
    property alias textAnchors: text.anchors

    readonly property real opacityEnabled: 1
    readonly property real opacityDisabled: 0.5
    opacity: enabled ? opacityEnabled : opacityDisabled

    contentItem:
    Rectangle{
        color: button.pressed ? ViaviStyle.colors.selectedColor : ViaviStyle.colors.activeColor

        Text{
            id: text
            
            anchors.fill: parent
            anchors.margins: ViaviStyle.layouts.smallMargin

            horizontalAlignment: Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter

            text: button.text
            font: ViaviStyle.layouts.activeBoldTextFont
            color: ViaviStyle.colors.activeItemTextColor
        }
    }
}
