import QtQuick 2.5
import "ViaviStyle"

FiberContainer {
    id: root
    
    property int noOfPorts: polarity_res_nbPorts.value
    property bool isDataAvailable: noOfPorts > 0
    
    property bool isRunning: polarity_res_isTestRunning.value

    Column{
        id: buttonColumn
        
        width: ViaviStyle.layouts.buttonHeight * 3
        
        anchors.right: parent.right
        anchors.rightMargin: ViaviStyle.layouts.largeMargin
        anchors.top: parent.top
        anchors.topMargin: ViaviStyle.layouts.mediumMargin
        anchors.bottom: parent.bottom
        anchors.bottomMargin: ViaviStyle.layouts.mediumMargin

        spacing: ViaviStyle.layouts.mediumMargin
        
        Rectangle {
        	anchors.horizontalCenter: parent.horizontalCenter
        	
        	visible: isRunning
        	
        	color: "transparent"
		    	
	    	width: ViaviStyle.layouts.buttonHeight
	    	height: width
		    	
	        FiberColorImage{
		    	anchors.fill: parent
		        source: ViaviStyle.images.fixLinkTestingTimer
	    	}
	    	
	    	RotationAnimation on rotation {
		        loops: Animation.Infinite
		        from: 0
		        to: 360
		        duration: 1000
		        running: parent.visible
		    	}
    	}
        
        FiberImageButton{
	    	visible: !isRunning
	    	
	    	anchors.horizontalCenter: parent.horizontalCenter
	    	
	    	width: ViaviStyle.layouts.buttonHeight
	    	height: width
	    	
	        source: ViaviStyle.images.startCircleIcon
	        
	        onClicked:{
	            polarity_act_startMapping.invoke()
	        }
    	}

        Text {
        	visible: false
            text: polarity_res_expectedPolarityLabel.value+": " + polarity_res_expectedPolarityValue.value
            font: ViaviStyle.layouts.mediumBoldFont
            color: ViaviStyle.colors.mainInfoColor
        }

        Text {
        	visible: true
            text: polarity_res_foundPolarityLabel.value + ": "
            font: ViaviStyle.layouts.mediumBoldFont
            color: ViaviStyle.colors.mainInfoColor
        }
        
        Text {
        	visible: isDataAvailable
            text: polarity_res_expectedPolarityValue.value
            font: ViaviStyle.layouts.mediumBoldFont
            color: ViaviStyle.colors.mainInfoColor
            
            anchors.horizontalCenter: parent.horizontalCenter
        }
    }

    Item {
        id: mappingItem
        anchors.right:buttonColumn.left
        anchors.rightMargin: ViaviStyle.layouts.largeMargin * 2
        anchors.top: parent.top
        anchors.topMargin: ViaviStyle.layouts.mediumMargin
        anchors.bottom: parent.bottom
        anchors.bottomMargin: ViaviStyle.layouts.mediumMargin
        anchors.left: parent.left
        anchors.leftMargin: ViaviStyle.layouts.largeMargin * 2

        Rectangle{
            id: unitALabel
            anchors.horizontalCenter: parent.horizontalCenter
            anchors.top: parent.top
            height: parent.height * 0.15
            width: parent.width / 4
            color: "#666666" //ViaviStyle.colors.mainInfoColor
            Text {
                anchors.centerIn: parent
                text: polarity_res_unitALabel.value
                font: ViaviStyle.layouts.mediumBoldFont
                color: ViaviStyle.colors.activeItemTextColor
            }
        }

        Rectangle {
            id: unitAPortsRect
            anchors.top: unitALabel.bottom
            height: ViaviStyle.layouts.buttonHeight * 0.7
            anchors.left: parent.left
            anchors.right: parent.right

            color: root.isDataAvailable? "#666666" : "transparent"//ViaviStyle.colors.mainInfoColor
            border.color: root.isDataAvailable? "transparent":"#666666"
            border.width: ViaviStyle.layouts.borderSmallWidth

            Row {
                anchors.centerIn: parent

                Repeater {
                    //id: mappingRepeater

                    model: polarity_res_mappingList.value

                    delegate: //Column {

                        Rectangle {
                            height: unitAPortsRect.height * 0.9
                            width: unitAPortsRect.width / ( root.noOfPorts + 1 )
                            color: isRunning ? ViaviStyle.colors.getColor( 0 ) : root.isDataAvailable ? ViaviStyle.colors.getColor( model.linkState ) : ViaviStyle.colors.getColor( 0 )
                            border.width: ViaviStyle.layouts.borderSize
                            border.color: "#666666"//ViaviStyle.colors.mainInfoColor
                            Text {
                                anchors.centerIn: parent
                                visible: root.isDataAvailable && (model.linkState !== 0)
                                text: model.portIndex
                                color: ViaviStyle.colors.activeItemTextColor
                                font: ViaviStyle.layouts.mediumBoldFont
                            }
                        }
                    //}
                }
            }
        }

        Item {
            id: connectedRect
            anchors.top: unitAPortsRect.bottom
            height: ViaviStyle.layouts.buttonHeight * 0.7
            anchors.left: parent.left
            anchors.right: parent.right

            //color: "transparent"

            Row {
                anchors.centerIn: parent

                Repeater {
                    model: polarity_res_mappingList.value

                    delegate: //Column {

                        Rectangle {
                            height: connectedRect.height
                            width: connectedRect.width / ( root.noOfPorts + 1 )
                            color: "transparent"

                            Rectangle {
                                anchors.centerIn: parent
                                visible: root.isDataAvailable && model.linkState !== 0
                                height: parent.height
                                width: ViaviStyle.layouts.borderSize * 3
                                color: ViaviStyle.colors.mainInfoColor
                            }
                        }
                  //  }
                }
            }
        }

        Rectangle {
            id: unitBPortsRect

            anchors.top: connectedRect.bottom
            height: ViaviStyle.layouts.buttonHeight * 0.7
            anchors.left: parent.left
            anchors.right: parent.right

            color: root.isDataAvailable? "#666666" : "transparent"//ViaviStyle.colors.mainInfoColor
            border.color: root.isDataAvailable? "transparent":"#666666"
            border.width: ViaviStyle.layouts.borderSmallWidth
            
            visible: isDataAvailable

            Row {
                anchors.centerIn: parent

                Repeater {
                    id: mappingBRepeater

                    model: polarity_res_mappingList.value

                    delegate: //Column {

                        Rectangle {
                            height: unitBPortsRect.height * 0.9
                            width: unitBPortsRect.width /  ( root.noOfPorts + 1 )
                            color: isRunning ? ViaviStyle.colors.getColor( 0 ) : root.isDataAvailable ? ViaviStyle.colors.getColor( model.linkState ) : ViaviStyle.colors.getColor( 0 )
                            border.width: ViaviStyle.layouts.borderSize
                            border.color: "#666666"//ViaviStyle.colors.mainInfoColor
                            Text {
                                anchors.centerIn: parent
                                visible: root.isDataAvailable && (model.linkState !== 0)
                                text: model.connectedPortIndex
                                color: ViaviStyle.colors.activeItemTextColor
                                font: ViaviStyle.layouts.mediumBoldFont
                            }
                        }
                   // }
                }
            }
        }


        Rectangle{
            id: unitBLabel
            anchors.horizontalCenter: parent.horizontalCenter
            anchors.top: unitBPortsRect.bottom
            height: parent.height * 0.15
            width: parent.width / 4
            color: "#666666"//ViaviStyle.colors.mainInfoColor
            
            visible: isDataAvailable
            
            Text {
                anchors.centerIn: parent
                text: polarity_res_unitBLabel.value
                font: ViaviStyle.layouts.mediumBoldFont
                color: ViaviStyle.colors.activeItemTextColor

            }
        }
    }
}

