import QtQuick 2.3
import QtQuick.Layouts 1.1
import "ViaviStyle"

Item{
    height: ViaviStyle.layouts.buttonHeight

    Row{
        id: buttonsRow
        anchors.right: parent.right
        anchors.rightMargin: ViaviStyle.layouts.mediumMargin

        spacing: ViaviStyle.layouts.mediumMargin

        FiberImageButton{
            source: ViaviStyle.images.reloadIcon

            visible: generictable_res_genericTableNbLineData.value >  generictable_res_currentIndex.value

            onClicked:{
                fcomp_act_cableLineRedoAction.invoke()
            }
        }

        FiberImageButton{
            source: ViaviStyle.images.clearIcon

            visible: generictable_res_genericTableNbLineData.value >  generictable_res_currentIndex.value

            onClicked:{
                fcomp_act_cableLineDeleteAction.invoke()
            }
        }

        Item{
            width: ViaviStyle.layouts.buttonHeight / 3

            anchors.top: parent.top
            anchors.bottom: parent.bottom
        }

        FiberImageButton{
            source: ViaviStyle.images.deleteIcon

            visible: generictable_res_genericTableNbLineData.value > 0

            onClicked:{
                fcomp_act_cableLineClearAction.invoke()
            }
        }
    }
}
