import QtQuick 2.3
import QtQuick.Controls 2.0
import base_plugin 1.0
import elf_plugin 1.0
import QtQuick.Layouts 1.2

import "ViaviStyle"

Rectangle {
    id: rootItem

    default property alias rowData: rowId.data
    property alias rectData: rootItem.data
    property alias colData: columnId.data
    property alias overlayData: overlayId.data
    property bool expanded: false
    property string event_name : ""
    property int event_alarm: 0
    property string event_threshold1: ""
    property string event_threshold2: ""
    property string event_diagnosisCause: ''
    property string event_problemEvent: ''
    property real frameSizeH: 0
    property real frameSizeV: 0

    property alias showIf: rootItem.visible

    property alias mainContentHeight: rowId.height

    property alias columnSpacing: rowId.spacing

    height: showIf ? (columnId.height) : 0
    color: expanded ? ViaviStyle.colors.alternativeBackgroundColor : ViaviStyle.colors.contentBackgroundColor
    border.width: expanded ? ViaviStyle.layouts.borderSmallWidth : 0
    border.color: ViaviStyle.colors.borderColor
    width: parent.width

    Column {
        id: columnId

        anchors.left: parent.left
        anchors.right: parent.right
        anchors.leftMargin: frameSizeH
        anchors.rightMargin: frameSizeH

        RowLayout{
            id: rowId

            anchors.left: parent.left
            anchors.right: parent.right
        }

        HorizontalSeparator{
            visible: !expanded
            anchors.left: parent.left
            anchors.leftMargin: ViaviStyle.layouts.smallMargin
            anchors.right: parent.right
            anchors.rightMargin: ViaviStyle.layouts.smallMargin
        }

        Item {
            id: itemId
            visible: expanded

            anchors.left: parent.left
            anchors.right: parent.right

            height: statusRect.height + 2 * frameSizeV

            FiberContainer{
                id: statusRect

                anchors.left: parent.left
                anchors.right: parent.right
                anchors.verticalCenter: parent.verticalCenter

                height: Math.max( detailTextColumn.height + 2 * ViaviStyle.layouts.mediumMargin,
                                 ViaviStyle.layouts.imageButtonHeight + ViaviStyle.layouts.smallMargin )

                Rectangle{
                    id: colorStatusRect
                    height: parent.height
                    width: parent.width/10
                    anchors.left: parent.left
                    color: ViaviStyle.colors.getColor(event_alarm)
                    FiberColorImage {
                        id:eventIcon
                        height: ViaviStyle.layouts.imageButtonHeight
                        width: parent.width
                        anchors.centerIn: parent
                        fillMode: Image.PreserveAspectFit
                        source: ViaviStyle.images.getAlarmIcon(event_alarm)
                        color: ViaviStyle.colors.activeItemTextColor
                    }
                }

                ColumnLayout {
                    id: detailTextColumn
                    anchors.left: colorStatusRect.right
                    anchors.right: parent.right
                    anchors.top: parent.top
                    anchors.margins: ViaviStyle.layouts.mediumMargin
                    spacing: ViaviStyle.layouts.smallMargin

                    Text {
                        id: eventNameText
                        Layout.fillWidth: true
                        horizontalAlignment:Text.AlignHCenter
                        verticalAlignment: Text.AlignVCenter
                        font: ViaviStyle.layouts.titleTextFont
                        color: ViaviStyle.colors.mainInfoColor
                        wrapMode: Text.WordWrap
                        text: event_name
                    }

                    Text {
                        id: eventProblemText
                        Layout.fillWidth: true
                        horizontalAlignment:Text.AlignHCenter
                        verticalAlignment: Text.AlignVCenter
                        font: ViaviStyle.layouts.activeTextFont
                        color: ViaviStyle.colors.mainInfoColor
                        wrapMode: Text.WordWrap
                        text: event_problemEvent
                        visible: text && text.length > 0
                    }

                    Text {
                        id: threshold1
                        Layout.fillWidth: true
                        horizontalAlignment: Text.AlignHCenter
                        verticalAlignment: Text.AlignVCenter
                        font: ViaviStyle.layouts.activeTextFont
                        color: ViaviStyle.colors.secondaryInfoColor
                        wrapMode: Text.WordWrap
                        text: event_threshold1
                        visible: text && text.length > 0
                    }

                    Text {
                        id: threshold2
                        Layout.fillWidth: true
                        horizontalAlignment: Text.AlignHCenter
                        verticalAlignment: Text.AlignVCenter
                        font: ViaviStyle.layouts.activeTextFont
                        color: ViaviStyle.colors.secondaryInfoColor
                        wrapMode: Text.WordWrap
                        text: event_threshold2
                        visible: text && text.length > 0
                    }

                    Text {
                        id: diagnosisCause
                        Layout.fillWidth: true
                        horizontalAlignment: Text.AlignHCenter
                        verticalAlignment: Text.AlignVCenter
                        font: ViaviStyle.layouts.activeTextFont
                        color: ViaviStyle.colors.secondaryInfoColor
                        wrapMode: Text.WordWrap
                        text: event_diagnosisCause
                        visible: text && text.length > 0
                    }
                }
            }
        }
    }

    Item{
        id: overlayId
        anchors.fill: parent
    }
}
