import QtQuick 2.7
import elf_plugin 1.0
import base_plugin 1.0
import QtQuick.Layouts 1.2
import "ViaviStyle"
FiberContainer {
    id: rootItem

    readonly property real scaleFactor: ViaviStyle.layouts.isSmallScreen ? 0.7 : 1
    property int alarm: events_res_alarm.value

    property FiberPopup eventPopup

    property double firstItemDistance
    property double lastItemDistance

    function getTableText(value){
        if(value === ""){
            return "--"
        }
        return value
    }

    function getTextColor(alarm, text){
        if(text === ""){
            return ViaviStyle.colors.mainInfoColor
        }else{
            return ViaviStyle.colors.getTextColor(alarm)
        }
    }

    Item{
        anchors.fill:parent
        anchors.margins: ViaviStyle.layouts.borderSize

        ToggleButtonOption {
            id: tButton
            height: ViaviStyle.layouts.buttonHeight
            anchors.left: parent.left
            anchors.leftMargin: ViaviStyle.layouts.largeMargin
            anchors.verticalCenter: headerRow.verticalCenter

            leftText: events_res_allLabel.value
            rightText: events_res_failedLabel.value
        }

        Component{
            id: headerText

            Text{
                id: laserTextId

                height: contentHeight
                anchors.verticalCenter: parent.verticalCenter
                horizontalAlignment: Text.AlignHCenter

                color: ViaviStyle.colors.secondaryInfoColor
                font : ViaviStyle.layouts.headerFont

                text: laserName
            }
        }

        Row{
            id: headerRow

            anchors.top: parent.top
            anchors.topMargin: ViaviStyle.layouts.largeMargin * rootItem.scaleFactor
            anchors.right: parent.right
            anchors.rightMargin: ViaviStyle.layouts.largeMargin

            height: Math.max( laserId0.height + ViaviStyle.layouts.mediumMargin, tButton.height )
            spacing: ViaviStyle.layouts.largeMargin * rootItem.scaleFactor

            Loader{
                id: laserId0

                property string laserName: events_res_laserLabel0.value
                visible: laserName

                sourceComponent: headerText
            }

            Loader{
                id: laserId1

                property string laserName: events_res_laserLabel1.value
                visible: laserName

                sourceComponent: headerText
            }

            Loader{
                id: laserId2

                property string laserName: events_res_laserLabel2.value
                visible: laserName

                sourceComponent: headerText
            }

            Loader{
                id: laserId3

                property string laserName: events_res_laserLabel3.value
                visible: laserName

                sourceComponent: headerText
            }
        }

        ListView {
            id: theListView
            boundsBehavior: Flickable.OvershootBounds
            anchors.top: headerRow.bottom
            anchors.bottom: parent.bottom

            anchors.left: parent.left
            anchors.right: parent.right

            focus: true
            clip: true
            currentIndex: events_res_traceCurrentEventIndex.value
            keyNavigationWraps: true
            model: events_res_eventsData.value
            
            property bool isListCompleted: false

            property int columnSpacingWidth: Math.min(ViaviStyle.layouts.largeMargin, emptySpaceWidth / numberOfSpaces)
            property int emptySpaceWidth: width - eventIdColumnWidth - imageColumnWidth - firstColumn2Width
                                          - separatorRowWidth - firstColumn3Width - (laserValueWidth * noOfVisibleLasers)

            property int numberOfSpaces: 5 + (noOfVisibleLasers + 1) //5 = eventIdColumn + imageColumn + firstColumn2Column + separatorRow + firstColumn3
            property int leftSpaceWidth: (emptySpaceWidth - columnSpacingWidth * numberOfSpaces) / (noOfVisibleLasers + 1)

            property int eventIdColumnWidth: ViaviStyle.layouts.largeBoldFontMetrics.averageCharacterWidth * 3
            property int imageColumnWidth: ViaviStyle.layouts.imageButtonHeight * 2
            property int distanceLabelWidth: ViaviStyle.layouts.headerFontMetrics.advanceWidth( events_res_distanceLabel.value )
            property int sectionLabelWidth: ViaviStyle.layouts.headerFontMetrics.advanceWidth( events_res_sectionLabel.value )

            property int firstColumn2Width: Math.max(distanceLabelWidth, sectionLabelWidth, firstColumn2ValueWidth)
            property int firstColumn2ValueWidth: ViaviStyle.layouts.tableFontMetrics.averageCharacterWidth * 8
            property int separatorRowWidth: ViaviStyle.layouts.separatorSize

            property int lossLabelWidth: ViaviStyle.layouts.headerFontMetrics.advanceWidth( events_res_lossLabel.value )
            property int reflectanceLabelWidth: ViaviStyle.layouts.headerFontMetrics.advanceWidth( events_res_reflectLabel.value )
            property int slopeLabelWidth: ViaviStyle.layouts.headerFontMetrics.advanceWidth( events_res_slopeLabel.value )
            property int firstColumn3Width: Math.max(lossLabelWidth, reflectanceLabelWidth, slopeLabelWidth)

            // 1st laser is always visible + 2nd/3rd/4th laser columns visibility
            property int noOfVisibleLasers: 1 + (events_res_laserLabel1.value !== "" ? 1 : 0) +
                                            (events_res_laserLabel2.value !== "" ? 1 : 0) +
                                            (events_res_laserLabel3.value !== "" ? 1 : 0)
            property int laserValueWidth: ViaviStyle.layouts.tableFontMetrics.averageCharacterWidth * 5

            function updateFirstLastEvent() {
                var startItem = theListView.itemAt(theListView.width * 0.5, theListView.contentY )
                if (startItem) {
                    if (startItem.modelIndex === 0 && theListView.contentY === startItem.y){
                        //the events table doesn't have the first element in the minislm. if at the top use the saved value
                        rootItem.firstItemDistance = schematic_res_firstEntryPosition.value
                    } else {
                        rootItem.firstItemDistance = startItem.distance
                    }
                } else {
                    rootItem.firstItemDistance = 0
                }

                var endItem = theListView.itemAt(theListView.width * 0.5, Math.min(theListView.contentY + theListView.height - 1
                                                                                   ,theListView.contentY + theListView.contentHeight - 1));

                if (endItem) {
                	if (endItem.isEvent === true) {
                		rootItem.lastItemDistance = endItem.distance
                	}
                	else {
                		rootItem.lastItemDistance = endItem.prevDistance
                	}
                }
            }

            Component.onCompleted: {
                theListView.isListCompleted = true
                updateFirstLastEvent()
            }

            onContentYChanged: {
                if ( theListView.isListCompleted === true) {
                    theListView.updateFirstLastEvent()
                }
            }

            onContentHeightChanged: {
                if ( theListView.isListCompleted === true ) {
                    theListView.updateFirstLastEvent()
                }
            }

            onCountChanged:{
                if(theListView.isListCompleted){
                    updateFirstLastEvent()
                }
                
                theListView.contentY = theListView.originY
            }

            delegate: EventsRow{
                id: delegateId

                property bool isEvent: model.index % 2 !== 0 ? !events_res_firstEntryEvent.value : events_res_firstEntryEvent.value
                property double prevDistance: model.prevDistance
                property double distance: model.distance
                
                frameSizeH: ViaviStyle.layouts.largeMargin
                frameSizeV: ViaviStyle.layouts.mediumMargin
                mainContentHeight: laser0Column.height
                columnSpacing: theListView.columnSpacingWidth

                event_name: eventName
                event_alarm: alarm
                event_problemEvent: model.problemEvent
                event_threshold1: model.threshold1
                event_threshold2: model.threshold2
                event_diagnosisCause: model.diagnosisCause
                showIf: tButton.toggled ? (alarm < 0) : true

                property int modelIndex: model.index

                //didn't manage to find another way in which to update the First Last event.
                //The ListView optimizes the drawing and sometimes the contentY/contentHeight doesn't update
                Component.onCompleted: {
                    if((theListView.contentY <= y && y <= theListView.contentY + theListView.height )
                            || (y <= theListView.contentY + theListView.height  && theListView.contentY + theListView.height <= y + height )){
                        theListView.updateFirstLastEvent()
                    }
                }

                onYChanged: {
                    if((theListView.contentY <= y && y <= theListView.contentY + theListView.height )
                            || (y <= theListView.contentY + theListView.height  && theListView.contentY + theListView.height <= y + height )){
                        theListView.updateFirstLastEvent()
                    }
                }

                rectData : [
                    PopupMouseArea {
                        anchors.fill: parent
                        z:1
                        visible: true
                        enabled: true

                        longPressMenu: delegateId.isEvent ? eventPopup : null

                        onBeforePressAndHold: {
                            schematic_cfg_slmCurrentEvent.value = model.eventId - 1
                            delegateId.expanded = true
                        }

                        onClicked: {
                            if(delegateId.expanded)
                                delegateId.expanded = false;
                            else delegateId.expanded = true;
                        }
                    }
                ]

                Column{
                    id: eventIdColumn

                    Layout.preferredWidth: theListView.eventIdColumnWidth
                    Layout.minimumWidth: theListView.eventIdColumnWidth
                    Layout.maximumWidth: theListView.eventIdColumnWidth

                    Text {
                        color: ViaviStyle.colors.mainInfoColor
                        font: ViaviStyle.layouts.largeBoldFont

                        height: contentHeight
                        width: parent.width

                        horizontalAlignment: Text.AlignHCenter
                        verticalAlignment: Text.AlignVCenter

                        text: delegateId.isEvent ? model.eventId : ""
                    }
                }

                Column{
                    id: imageColumn

                    Layout.preferredWidth: theListView.imageColumnWidth
                    Layout.minimumWidth: theListView.imageColumnWidth
                    Layout.maximumWidth: theListView.imageColumnWidth

                    bottomPadding: ViaviStyle.layouts.mediumMargin

                    FiberContainer{
                        id: imageContainer

                        height: ViaviStyle.layouts.imageButtonHeight
                        width: 2 * height

                        border.width: ViaviStyle.layouts.borderSmallWidth

                        FiberColorImage {
                            id: eventIcon
                            anchors.fill: parent
                            anchors.margins: ViaviStyle.layouts.smallMargin * 2
                            source: icon
                            fillMode: Image.PreserveAspectFit
                            smooth: true
                            color: ViaviStyle.colors.activeColor
                        }

                        // Indicator image displayed on top of eventIcon
                        Image {
                            visible: iconIndicator !== ""
                            anchors.fill: parent
                            anchors.margins: ViaviStyle.layouts.smallMargin * 2
                            source: iconIndicator
                            fillMode: Image.PreserveAspectFit
                            smooth: true
                        }

                        // * for manually modified event codes
                        Text {
                            visible: model.isIconManual
                            anchors.bottom: parent.bottom
                            anchors.bottomMargin: -ViaviStyle.layouts.largeBoldFontMetrics.height / 4
                            anchors.left: parent.left
                            anchors.leftMargin: ViaviStyle.layouts.mediumMargin / 2

                            color: ViaviStyle.colors.activeColor
                            font: ViaviStyle.layouts.largeBoldFont
                            text: "*"
                        }
                    }
                }

                ResultsTableColumn{
                    id: firstColumn2

                    Layout.preferredWidth: theListView.firstColumn2Width + Math.min(ViaviStyle.layouts.veryLargeMargin, theListView.leftSpaceWidth / 2)
                    Layout.minimumWidth: theListView.firstColumn2Width
                    Layout.maximumWidth: theListView.firstColumn2Width + Math.min(ViaviStyle.layouts.veryLargeMargin, theListView.leftSpaceWidth / 2)

                    isCaptionColumn: false

                    value1Text: delegateId.isEvent ? events_res_distanceLabel.value : events_res_sectionLabel.value
                    value2Text: delegateId.isEvent ? rootItem.getTableText(model.distance) : rootItem.getTableText(model.section)
                    value1Font: ViaviStyle.layouts.headerFont
                    value2Font: ViaviStyle.layouts.tableFont
                    value1Color: ViaviStyle.colors.secondaryInfoColor
                    value2Color: ViaviStyle.colors.mainInfoColor
                }

                Item{
                    id: separatorRow

                    Layout.fillHeight: true

                    Layout.preferredWidth: theListView.separatorRowWidth + Math.min(ViaviStyle.layouts.veryLargeMargin, theListView.leftSpaceWidth / 2)
                    Layout.minimumWidth: theListView.separatorRowWidth
                    Layout.maximumWidth: theListView.separatorRowWidth + Math.min(ViaviStyle.layouts.veryLargeMargin, theListView.leftSpaceWidth / 2)

                    VerticalSeparator{
                        id : separator1

                        anchors.horizontalCenter: parent.horizontalCenter
                        anchors.top : parent.top
                        anchors.bottom : parent.bottom
                        anchors.topMargin: ViaviStyle.layouts.mediumMargin
                        anchors.bottomMargin: ViaviStyle.layouts.mediumMargin
                    }
                }

                ResultsTableColumn{
                    id: firstColumn3

                    Layout.preferredWidth: theListView.firstColumn3Width
                    Layout.minimumWidth: theListView.firstColumn3Width
                    Layout.maximumWidth: theListView.firstColumn3Width

                    isCaptionColumn: true

                    value1Text: events_res_lossLabel.value
                    value2Text: delegateId.isEvent ? events_res_reflectLabel.value : events_res_slopeLabel.value
                    value1Font: ViaviStyle.layouts.headerFont
                    value2Font: ViaviStyle.layouts.headerFont
                    value1Color: ViaviStyle.colors.secondaryInfoColor
                    value2Color: ViaviStyle.colors.secondaryInfoColor
                }

                ResultsTableColumn{
                    id: laser0Column

                    Layout.preferredWidth: theListView.laserValueWidth + theListView.leftSpaceWidth
                    Layout.minimumWidth: theListView.laserValueWidth
                    Layout.maximumWidth: parent.width
                    Layout.fillWidth: true

                    onWidthChanged: {
                        if (visible) {
                            laserId0.width = width
                        }
                        //should find a more robust system and completly redo the whole component when there's time
                    }

                    centerContent: true
                    isCaptionColumn: false

                    value1Text: rootItem.getTableText(model.loss0)
                    value2Text: delegateId.isEvent ? rootItem.getTableText(model.reflectance0) : rootItem.getTableText(model.slope0)
                    value1Font: ViaviStyle.layouts.tableFont
                    value2Font: ViaviStyle.layouts.tableFont
                    value1Color: rootItem.getTextColor(model.alarm_loss0, model.loss0)
                    value2Color: delegateId.isEvent ? rootItem.getTextColor(model.alarm_reflect0, model.reflectance0) : rootItem.getTextColor(model.alarm_slope0, model.slope0)
                }

                ResultsTableColumn{
                    id: firstColumn5

                    Layout.preferredWidth: theListView.laserValueWidth + theListView.leftSpaceWidth
                    Layout.minimumWidth: theListView.laserValueWidth
                    Layout.maximumWidth: parent.width
                    Layout.fillWidth: true

                    onWidthChanged: {
                        if (visible) {
                            laserId1.width = width
                        }
                    }

                    visible : events_res_laserLabel1.value !== ""

                    centerContent: true
                    isCaptionColumn: false

                    value1Text: rootItem.getTableText(model.loss1)
                    value2Text: delegateId.isEvent ? rootItem.getTableText(model.reflectance1) : rootItem.getTableText(model.slope1)
                    value1Font: ViaviStyle.layouts.tableFont
                    value2Font: ViaviStyle.layouts.tableFont
                    value1Color: rootItem.getTextColor(model.alarm_loss1, model.loss1)
                    value2Color: delegateId.isEvent ? rootItem.getTextColor(model.alarm_reflect1, model.reflectance1) : rootItem.getTextColor(model.alarm_slope1, model.slope1)
                }

                ResultsTableColumn{
                    id: firstColumn6

                    Layout.preferredWidth: theListView.laserValueWidth + theListView.leftSpaceWidth
                    Layout.minimumWidth: theListView.laserValueWidth
                    Layout.maximumWidth: parent.width
                    Layout.fillWidth: true

                    onWidthChanged: {
                        if (visible) {
                            laserId2.width = width
                        }
                    }

                    visible : events_res_laserLabel2.value !== ""

                    centerContent: true
                    isCaptionColumn: false

                    value1Text: rootItem.getTableText(model.loss2)
                    value2Text: delegateId.isEvent ? rootItem.getTableText(model.reflectance2) : rootItem.getTableText(model.slope2)
                    value1Font: ViaviStyle.layouts.tableFont
                    value2Font: ViaviStyle.layouts.tableFont
                    value1Color: rootItem.getTextColor(model.alarm_loss2, model.loss2)
                    value2Color: delegateId.isEvent ? rootItem.getTextColor(model.alarm_reflect2, model.reflectance2) : rootItem.getTextColor(model.alarm_slope2, model.slope2)
                }

                ResultsTableColumn{
                    id: firstColumn12

                    Layout.preferredWidth: theListView.laserValueWidth + theListView.leftSpaceWidth
                    Layout.minimumWidth: theListView.laserValueWidth
                    Layout.maximumWidth: parent.width
                    Layout.fillWidth: true

                    onWidthChanged: {
                        if (visible) {
                            laserId3.width = width
                        }
                    }

                    visible : events_res_laserLabel3.value !== ""

                    centerContent: true
                    isCaptionColumn: false

                    value1Text: rootItem.getTableText(model.loss3)
                    value2Text: delegateId.isEvent ? rootItem.getTableText(model.reflectance3) : rootItem.getTableText(model.slope3)
                    value1Font: ViaviStyle.layouts.tableFont
                    value2Font: ViaviStyle.layouts.tableFont
                    value1Color: rootItem.getTextColor(model.alarm_loss3, model.loss3)
                    value2Color: delegateId.isEvent ? rootItem.getTextColor(model.alarm_reflect3, model.reflectance3) : rootItem.getTextColor(model.alarm_slope3, model.slope3)
                }

                overlayData:[
                    Item{
                        anchors.fill: parent

                        Rectangle{
                            anchors.left: parent.left
                            anchors.top: parent.top
                            anchors.bottom: parent.bottom

                            width: 2 * ViaviStyle.layouts.borderSize

                            color: ViaviStyle.colors.borderColor

                            visible: model.groupElementType !== schematic_res_groupElementTypeEnum.enums.egetNone
                        }

                        Rectangle{
                            anchors.right: parent.right
                            anchors.top: parent.top
                            anchors.bottom: parent.bottom

                            width: 2 * ViaviStyle.layouts.borderSize

                            color: ViaviStyle.colors.borderColor

                            visible: model.groupElementType !== schematic_res_groupElementTypeEnum.enums.egetNone
                        }

                        Rectangle{
                            anchors.right: parent.right
                            anchors.left: parent.left
                            anchors.top: parent.top

                            height: 2 * ViaviStyle.layouts.borderSize

                            color: ViaviStyle.colors.borderColor

                            visible: model.groupElementType === schematic_res_groupElementTypeEnum.enums.egetBegin
                        }
                        Rectangle{
                            anchors.right: parent.right
                            anchors.left: parent.left
                            anchors.bottom: parent.bottom

                            height: 2 * ViaviStyle.layouts.borderSize

                            color: ViaviStyle.colors.borderColor

                            visible: model.groupElementType === schematic_res_groupElementTypeEnum.enums.egetEnd
                        }
                    }
                ]
            }
        }
    }
}
