import QtQuick 2.7
import QtQuick.Controls 2.0

import "ViaviStyle"

Rectangle {
    id: root

    color: ViaviStyle.colors.pageBackgroundColor

    FiberContainer{
        id: container
        anchors.top: parent.top
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.bottom: infoArea.top

        anchors.leftMargin : ViaviStyle.layouts.largeMargin
        anchors.rightMargin : ViaviStyle.layouts.largeMargin

        anchors.topMargin : ViaviStyle.layouts.mediumMargin
        anchors.bottomMargin : ViaviStyle.layouts.mediumMargin

        SequentialAnimation {
            id: animation
            PropertyAnimation  {
                target: container
                property: "color"
                to: "yellow"
                duration: 750
            }
            PropertyAnimation  {
                target: container
                property: "color"
                to: ViaviStyle.colors.contentBackgroundColor
                duration: 750
            }
        }

        Connections{
            target: dtsBattery_res_updateScanFlag
            onValueChanged:{
                animation.start()
            }
        }

        Rectangle{
            id: heatMapBorder

            anchors.rightMargin :2 *  ViaviStyle.layouts.largeMargin
            anchors.leftMargin :2 *  ViaviStyle.layouts.largeMargin

            anchors.topMargin : 2 * ViaviStyle.layouts.largeMargin
            anchors.bottomMargin : 2 * ViaviStyle.layouts.largeMargin

            anchors.top: parent.top
            anchors.bottom: parent.bottom
            anchors.right: legend.left
            anchors.left: parent.left

            color: "transparent"

            border.color : ViaviStyle.colors.borderColor
            border.width: ViaviStyle.layouts.borderSize

            Image{
                id: image
                anchors.fill: parent
                anchors.margins: parent.border.width

                cache: false

                Connections{
                    target: dtsBattery_res_heatMapChangeFlag
                    onValueChanged:{
                        image.source = ""
                        image.source = dtsBattery_res_heatMapImgPath.value
                    }
                }

                Repeater{
                    model: dtsBattery_cfg_nbOfColumns.value

                    Rectangle{
                        anchors.top: parent.top
                        anchors.bottom: parent.bottom

                        anchors.topMargin: - ViaviStyle.layouts.largeMargin
                        anchors.bottomMargin: - ViaviStyle.layouts.largeMargin

                        width: ViaviStyle.layouts.borderSize

                        color: ViaviStyle.colors.borderColor

                        x: ((2 * model.index + 1 ) / (2 * dtsBattery_cfg_nbOfColumns.value)) * parent.width
                    }
                }

                Repeater{
                    model: dtsBattery_cfg_nbOfRows.value

                    Rectangle{
                        anchors.left: parent.left
                        anchors.right: parent.right

                        anchors.leftMargin: - ViaviStyle.layouts.largeMargin
                        anchors.rightMargin: - ViaviStyle.layouts.largeMargin

                        height: ViaviStyle.layouts.borderSize

                        color: ViaviStyle.colors.borderColor

                        y: ((2 * model.index + 1) / (2 * dtsBattery_cfg_nbOfRows.value )) * parent.height
                    }
                }
            }
        }


        HeatMapLegend{
            id: legend

            anchors.rightMargin :2 *  ViaviStyle.layouts.mediumMargin

            anchors.topMargin : 2 * ViaviStyle.layouts.mediumMargin
            anchors.bottomMargin : 2 * ViaviStyle.layouts.mediumMargin

            anchors.top: parent.top
            anchors.bottom: parent.bottom
            anchors.right: parent.right

            colorIntensity:  dtsBattery_cfg_colorIntensity.value / 255.0

            minValue: dtsBattery_cfg_minTemp.value
            maxValue: dtsBattery_cfg_maxTemp.value
        }
    }

    FiberContainer{
        id: infoArea
        anchors.bottom: parent.bottom
        anchors.left: parent.left
        anchors.right: parent.right

        height: ViaviStyle.layouts.buttonHeight * 2

        anchors.leftMargin : ViaviStyle.layouts.largeMargin
        anchors.rightMargin : ViaviStyle.layouts.largeMargin

        anchors.topMargin : ViaviStyle.layouts.mediumMargin
        anchors.bottomMargin : ViaviStyle.layouts.mediumMargin

        Item{
            anchors.fill: parent

            visible: dtsBattery_res_acqInProgress.value

            InprogressIcon{
                id: icon
                anchors.centerIn: parent
            }

            Text{
                anchors.left: icon.right
                anchors.verticalCenter:  icon.verticalCenter

                anchors.leftMargin : ViaviStyle.layouts.veryLargeMargin

                font: ViaviStyle.layouts.largeBoldFont

                text: dtsBattery_res_monitoringLabel.value
            }
        }
    }
}
