import QtQuick 2.3
import "./UtilUiQt/Viavi_Colors.js" as VColor

Rectangle {
    id: head
    color: VColor.cViaviColorGray
    
    Rectangle {
    	id: fiberFinder
    	
	    anchors.right: head.right
        anchors.verticalCenter: parent.verticalCenter
        
        height: head.height - 4
        width: height
        
        color: VColor.cViaviColorLightGray2
        
	    Image { // Find icons
	        fillMode: Image.PreserveAspectFit
	        source:"/acterna/storage/look-and-feel/generic/Icon_Search_32.png"
	        
	        anchors.fill: parent
	        anchors.margins: 2
	        
	        MouseArea {
	        	anchors.fill: parent
	        	onClicked: { openSearchKeyPad() }
	        }
	    }
    }
	
	Rectangle {
		id: recAllFiber
        width: ( parent.width / 2 ) - fiberFinder.width
        height: head.height - 4
		color: VColor.cViaviColorLightGray2
		// anchors.right: head.right
        anchors.right: fiberFinder.left
        anchors.verticalCenter: parent.verticalCenter
		
		Rectangle {
			id: recPassFiber
			color: VColor.cViaviColorGreen
			height:parent.height
			width: cable_co_list.Nb_Fiber > 0 ? recAllFiber.width * cable_co_list.Nb_Fiber_Pass / cable_co_list.Nb_Fiber_To_Test : 0
			anchors.left: parent.left
		}
		
		Rectangle {
			id: recFailFiber
			color: VColor.cViaviColorRed
			height:parent.height
			width: cable_co_list.Nb_Fiber > 0 ? recAllFiber.width * cable_co_list.Nb_Fiber_Fail / cable_co_list.Nb_Fiber_To_Test : 0
			anchors.left: recPassFiber.right
		}
		
		Text {
			id: textNumberFiberTested
            anchors.horizontalCenter: parent.horizontalCenter
            anchors.verticalCenter: parent.verticalCenter
            horizontalAlignment: Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter
			text: cable_co_list.Txt_Tested + ": " + (cable_co_list.Nb_Fiber_Done) + "/" + cable_co_list.Nb_Fiber_To_Test 
			color: "white"
            font.pixelSize: 24
            font.family: "DejaVu LGC SansCondensed"
		}
	}

    Image { // The icon metaphor
        id: passedMetaphor
        anchors.left: parent.left
        anchors.leftMargin: 10
        anchors.verticalCenter: parent.verticalCenter
        height: 32
        fillMode: Image.PreserveAspectFit
        source:"/acterna/storage/look-and-feel/generic/Check_32_Enterprise.png"
    }

	Text {
		id: textPassFiber
        anchors.left: passedMetaphor.right
		anchors.leftMargin: 10 //40
        anchors.verticalCenter: parent.verticalCenter
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        // Dont use italics
        text: cable_co_list.Nb_Fiber_Pass + " " + cable_co_list.Txt_Pass
		color: "white"
        font.pixelSize: 24
        font.family: "DejaVu LGC SansCondensed"
	}

    Image { // The icon metaphor
        id: failedMetaphor
        anchors.left: textPassFiber.right
        anchors.leftMargin: 20
        anchors.verticalCenter: parent.verticalCenter
        height: 32
        fillMode: Image.PreserveAspectFit
        source:"/acterna/storage/look-and-feel/generic/Cross_32_Enterprise.png"
    }
	
	Text {
		id: textFailFiber
		anchors.left: failedMetaphor.right
        anchors.leftMargin: 10
        anchors.verticalCenter: parent.verticalCenter
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        text: cable_co_list.Nb_Fiber_Fail + " " + cable_co_list.Txt_Fail
		color: "white"
        font.pixelSize: 24
        font.family: "DejaVu LGC SansCondensed"
	}
}
