import QtQuick 2.5
import QtQuick.Controls 2.0
import QtQuick.Layouts 1.2

import "./UtilUiQt/Viavi_Colors.js" as VColor
import "ViaviStyle"

import elf_plugin 1.0
import libfo 1.0

Rectangle {
	id: cable
	property int nb_col: 7
	color: "black"
	focus: true
	
	enabled: !cable_co_list.Event_Lock
    opacity: cable_co_list.Event_Lock ? 0.8 : 1
    
    function openSearchKeyPad() {
        // keyboard.visible = true;
        keyboardPopup.open()
        
        keyboard.minValue = cable_co_list.Cable_List[0].Fiber_Number
        keyboard.maxValue = cable_co_list.Nb_Fiber + cable_co_list.Cable_List[0].Fiber_Number - 1 
        
        keyboard.editText.connect(goToFiber);   
    }
    
    function goToFiber(txtOutput, validation) {   
        if (validation === true)
        	{
        	var searchIndex = txtOutput - cable_co_list.Cable_List[0].Fiber_Number - 1
            grid.positionViewAtIndex(searchIndex, GridView.Center)
        	}
             
        keyboard.editText.disconnect(goToFiber); 
    }

	Column {

		Cable_Co_Title {
			id: title
			height: grid.cellHeight / 3
			width: grid.cellWidth * nb_col
		}

		GridView {
			id: grid
			width : cable.width
			height : cable.height - cable_head.height - title.height
			currentIndex: cable_co_list.Index
			boundsBehavior: Flickable.StopAtBounds
			cellWidth : (cable.width / nb_col) - 1
			cellHeight : (cable.width / nb_col) - 1
			
			clip: true
	        
	        highlightMoveDuration: -1

			model: cable_co_list.Cable_List
			delegate: Cable_Co_One_Element {}
		}

		Cable_Co_Result_Informations {
			id: cable_head
			
			visible: cable_co_list.Result_Window_Displayed

			height: visible ? grid.cellHeight * 1.3 : 0
			width: grid.cellWidth * nb_col
		}
	}
	
	KeyboardUtils { id: keyboardUtils }
	
	Popup{
        id: keyboardPopup

        width: fiberMainPage.width
        height: fiberMainPage.height
        
        parent: cable
        
        anchors.centerIn: cable

        modal: true

        closePolicy: Popup.NoAutoClose

        background: Rectangle{
            anchors.fill: parent
            color: ViaviStyle.colors.transparentBackgroundColor
        }

        contentItem: Item{
            anchors.fill: parent

            KeyboardNumerical{
                id: keyboard
                
                // visible: false
                
                property int inputTextMinLength: 1
    			inputTextMaxLength: 64
    			
    			dotIsAllowed: false
    			titleText: cable_co_list.Txt_Go_To_Fiber
                
                signal editText(string txtOutput, bool validation)

			    onAccepted: {
			        editText(textField, true);
			        // root.visible = false
			        
			        keyboardPopup.close()
			    }
			
			    onCanceled: {
			        editText(textField, false);
			        // root.visible = false
			        
			        keyboardPopup.close()
			    }
            }
        }
    }  

	Keys.onPressed: {
		if (event.key == Qt.Key_Left) {
			if (cable_co_list.Index > 0) {
				cable_co_list.Index = cable_co_list.Index - 1;
			}
		} else if (event.key == Qt.Key_Right) {
			if (cable_co_list.Index < (grid.count - 1)) {
				cable_co_list.Index = cable_co_list.Index + 1;
			}
		} else if (event.key == Qt.Key_Up) {
			if ((cable_co_list.Index - nb_col) >= 0) {
			    cable_co_list.Index = cable_co_list.Index - nb_col;
			}
		} else if (event.key == Qt.Key_Down) {
			if ((cable_co_list.Index + nb_col) < grid.count) {
			    cable_co_list.Index = cable_co_list.Index + nb_col;
			}
		}
	}
}
