import QtQuick 2.3
import libfo 1.0
import "./UtilUiQt/Viavi_Colors.js" as VColor

Item {
    property bool selected: ( cable_co_list.Label_Index == index  && cable_co_list.Label_Selection_Mode != false )
    property bool open: ( index == cable_co_list.Label_Index_Open )
    
    visible: label_text.text.toString().includes(filterLabel)

    width: label_list.width
    // height: (open) ? 64 * 3 : 48
    height: visible ? ( open ? 64 * 3 : 48 ) : 0
    
    function cable_get_label_icon( status )
	{
      var icon = "";
	  
	  if ( status == Label.CLabel_Status_Failed )
	  {
	    icon = "/acterna/storage/look-and-feel/generic/Cross_32_Enterprise.png";
	  }
	  else if ( status == Label.CLabel_Status_Ok )
	  {
	    icon = "/acterna/storage/look-and-feel/generic/Check_32_Enterprise.png";
	  }
	  else if ( status == Label.CLabel_Status_In_Progress )
	  {
	    icon = "/acterna/storage/look-and-feel/generic/Progress_32_Enterprise.png";
	  }
	  
	  return icon;
	}
	
	function cable_get_label_color( status )
	{
		var cable_back_col = VColor.cViaviColorLightGray2;
		
		if ( status == Label.CLabel_Status_Not_To_test )
		{
		cable_back_col = VColor.cViaviColorGray;
		}
		
		return cable_back_col;
	}

    Rectangle {
        id: line
        anchors.fill: parent

        color: selected ? VColor.cViaviColorMediumBlue : cable_get_label_color( Label_Status )
        border.color: VColor.cViaviColorDarkGray
        border.width: 2

        Item {
            id: label_holder
            height: 32
            anchors.left: expander_image.right
            anchors.right: (label_status_image.source.toString().length > 0) ? label_status_image.left : parent.right
            anchors.leftMargin: 3
            anchors.rightMargin: 3
            anchors.topMargin: 8
            anchors.top : parent.top

            clip: true

            Text {
                id: label_text
                width: parent.width
                height: parent.height
                text: Label_Name
                color: VColor.cViaviColorLogoPurple
                font.pixelSize: 24
                font.family: "Bitstream Vera Sans Roman"
                horizontalAlignment: Text.AlignLeft
                verticalAlignment: Text.AlignVCenter
            }
        }

        Image {
            id: label_status_image
            height: 32
            width: 32
            anchors.right : parent.right
            anchors.top : parent.top
            source: cable_get_label_icon( Label_Status )
            anchors.rightMargin: 10
            anchors.topMargin: 8
        }
        
        Image {
            id: expander_image
            height: 32
            width: 32
            anchors.left : parent.left
            visible: cable_co_list.MPO_Size > 1
            anchors.top : parent.top
            source: open ? "/acterna/storage/look-and-feel/generic/Open_32.png" : "/acterna/storage/look-and-feel/generic/Close_32.png"
            anchors.leftMargin: 5
            anchors.topMargin: 8
        }
        
        MouseArea {
            anchors.fill: parent

            drag.target: label_text
            drag.axis: Drag.XAxis
            drag.minimumX: drag.target.width > drag.target.contentWidth ? 0 : drag.target.width - drag.target.contentWidth
            drag.maximumX: 0

            onClicked: {
            	if ( selected )
            	{
            		cable_co_list.Label_Index_Open = ( index != cable_co_list.Label_Index_Open ? index : -1 );
            	}
            	else
            	{
            		cable_co_list.Label_Index = index;
            	}
            	
           		cable_co_list.Label_Selection_Mode = true
            	cable_co_list.Index = cable_co_list.Cable_Co_Get_First_Index_Of_Label(index);
            }
        } 
    }
}
